/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperationEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;

public abstract class RelationalOperationEval
implements OperationEval {
    public RelationalValues doEvaluate(Eval[] evalArray, int n, short s) {
        RelationalValues relationalValues = new RelationalValues();
        switch (evalArray.length) {
            default: {
                relationalValues.ee = ErrorEval.VALUE_INVALID;
                break;
            }
            case 2: {
                this.internalDoEvaluate(evalArray, n, s, relationalValues, 0);
                this.internalDoEvaluate(evalArray, n, s, relationalValues, 1);
            }
        }
        return relationalValues;
    }

    private void internalDoEvaluate(Eval[] evalArray, int n, short s, RelationalValues relationalValues, int n2) {
        if (evalArray[n2] instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)evalArray[n2];
            relationalValues.bs[n2] = boolEval.getBooleanValue();
        } else if (evalArray[n2] instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)evalArray[n2];
            relationalValues.ds[n2] = new Double(numericValueEval.getNumberValue());
        } else if (evalArray[n2] instanceof StringValueEval) {
            StringValueEval stringValueEval = (StringValueEval)evalArray[n2];
            relationalValues.ss[n2] = stringValueEval.getStringValue();
        } else if (evalArray[n2] instanceof RefEval) {
            RefEval refEval = (RefEval)evalArray[n2];
            ValueEval valueEval = refEval.getInnerValueEval();
            if (valueEval instanceof BoolEval) {
                BoolEval boolEval = (BoolEval)valueEval;
                relationalValues.bs[n2] = boolEval.getBooleanValue();
            } else if (valueEval instanceof BlankEval) {
                relationalValues.ds[n2] = new Double(0.0);
            } else if (valueEval instanceof NumericValueEval) {
                NumericValueEval numericValueEval = (NumericValueEval)valueEval;
                relationalValues.ds[n2] = new Double(numericValueEval.getNumberValue());
            } else if (valueEval instanceof StringValueEval) {
                StringValueEval stringValueEval = (StringValueEval)valueEval;
                relationalValues.ss[n2] = stringValueEval.getStringValue();
            }
        } else if (evalArray[n2] instanceof AreaEval) {
            AreaEval areaEval = (AreaEval)evalArray[n2];
            if (areaEval.isRow()) {
                if (areaEval.containsColumn(s)) {
                    ValueEval valueEval = areaEval.getValueAt(areaEval.getFirstRow(), s);
                    if (valueEval instanceof BoolEval) {
                        BoolEval boolEval = (BoolEval)valueEval;
                        relationalValues.bs[n2] = boolEval.getBooleanValue();
                    } else if (valueEval instanceof BlankEval) {
                        relationalValues.ds[n2] = new Double(0.0);
                    } else if (valueEval instanceof NumericValueEval) {
                        NumericValueEval numericValueEval = (NumericValueEval)valueEval;
                        relationalValues.ds[n2] = new Double(numericValueEval.getNumberValue());
                    } else if (valueEval instanceof StringValueEval) {
                        StringValueEval stringValueEval = (StringValueEval)valueEval;
                        relationalValues.ss[n2] = stringValueEval.getStringValue();
                    } else {
                        relationalValues.ee = ErrorEval.VALUE_INVALID;
                    }
                } else {
                    relationalValues.ee = ErrorEval.VALUE_INVALID;
                }
            } else if (areaEval.isColumn()) {
                if (areaEval.containsRow(n)) {
                    ValueEval valueEval = areaEval.getValueAt(n, areaEval.getFirstColumn());
                    if (valueEval instanceof BoolEval) {
                        BoolEval boolEval = (BoolEval)valueEval;
                        relationalValues.bs[n2] = boolEval.getBooleanValue();
                    } else if (valueEval instanceof BlankEval) {
                        relationalValues.ds[n2] = new Double(0.0);
                    } else if (valueEval instanceof NumericValueEval) {
                        NumericValueEval numericValueEval = (NumericValueEval)valueEval;
                        relationalValues.ds[n2] = new Double(numericValueEval.getNumberValue());
                    } else if (valueEval instanceof StringValueEval) {
                        StringValueEval stringValueEval = (StringValueEval)valueEval;
                        relationalValues.ss[n2] = stringValueEval.getStringValue();
                    } else {
                        relationalValues.ee = ErrorEval.VALUE_INVALID;
                    }
                } else {
                    relationalValues.ee = ErrorEval.VALUE_INVALID;
                }
            } else {
                relationalValues.ee = ErrorEval.VALUE_INVALID;
            }
        }
    }

    protected int doComparison(Boolean[] booleanArray) {
        int n = 0;
        if (booleanArray[0] != null || booleanArray[1] != null) {
            n = booleanArray[0] != null ? (booleanArray[1] != null ? (booleanArray[0].booleanValue() ? (booleanArray[1].booleanValue() ? 0 : 1) : (booleanArray[1].booleanValue() ? -1 : 0)) : 1) : (booleanArray[1] != null ? -1 : 0);
        }
        return n;
    }

    protected int doComparison(String[] stringArray) {
        int n = 0;
        if (stringArray[0] != null || stringArray[1] != null) {
            n = stringArray[0] != null ? (stringArray[1] != null ? stringArray[0].compareTo(stringArray[1]) : 1) : (stringArray[1] != null ? -1 : 0);
        }
        return n;
    }

    protected int doComparison(Double[] doubleArray) {
        int n = 0;
        if (doubleArray[0] != null || doubleArray[1] != null) {
            n = doubleArray[0] != null ? (doubleArray[1] != null ? doubleArray[0].compareTo(doubleArray[1]) : 1) : (doubleArray[1] != null ? -1 : 0);
        }
        return n;
    }

    protected class RelationalValues {
        public Double[] ds = new Double[2];
        public Boolean[] bs = new Boolean[2];
        public String[] ss = new String[3];
        public ErrorEval ee = null;

        protected RelationalValues() {
        }
    }
}

