/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class OperandResolver {
    private OperandResolver() {
    }

    public static ValueEval getSingleValue(Eval eval, int n, short s) throws EvaluationException {
        Eval eval2 = eval instanceof RefEval ? ((RefEval)eval).getInnerValueEval() : (eval instanceof AreaEval ? OperandResolver.chooseSingleElementFromArea((AreaEval)eval, n, s) : eval);
        if (eval2 instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)eval2);
        }
        if (eval2 instanceof ValueEval) {
            return eval2;
        }
        throw new RuntimeException("Unexpected eval type (" + eval2.getClass().getName() + ")");
    }

    public static ValueEval chooseSingleElementFromArea(AreaEval areaEval, int n, short s) throws EvaluationException {
        ValueEval valueEval = OperandResolver.chooseSingleElementFromAreaInternal(areaEval, n, s);
        if (valueEval == null) {
            valueEval = BlankEval.INSTANCE;
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        return valueEval;
    }

    private static ValueEval chooseSingleElementFromAreaInternal(AreaEval areaEval, int n, short s) throws EvaluationException {
        if (areaEval.isColumn()) {
            if (areaEval.isRow()) {
                return areaEval.getValues()[0];
            }
            if (!areaEval.containsRow(n)) {
                throw EvaluationException.invalidValue();
            }
            return areaEval.getValueAt(n, areaEval.getFirstColumn());
        }
        if (!areaEval.isRow()) {
            if (areaEval.containsRow(n) && areaEval.containsColumn(s)) {
                return areaEval.getValueAt(areaEval.getFirstRow(), areaEval.getFirstColumn());
            }
            throw EvaluationException.invalidValue();
        }
        if (!areaEval.containsColumn(s)) {
            throw EvaluationException.invalidValue();
        }
        return areaEval.getValueAt(areaEval.getFirstRow(), s);
    }

    public static int coerceValueToInt(ValueEval valueEval) throws EvaluationException {
        double d = OperandResolver.coerceValueToDouble(valueEval);
        return (int)Math.floor(d);
    }

    public static double coerceValueToDouble(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof NumericValueEval) {
            return ((NumericValueEval)valueEval).getNumberValue();
        }
        if (valueEval instanceof StringEval) {
            Double d = OperandResolver.parseDouble(((StringEval)valueEval).getStringValue());
            if (d == null) {
                throw EvaluationException.invalidValue();
            }
            return d;
        }
        throw new RuntimeException("Unexpected arg eval type (" + valueEval.getClass().getName() + ")");
    }

    public static Double parseDouble(String string) {
        double d;
        String string2 = string.trim();
        if (string2.length() < 1) {
            return null;
        }
        boolean bl = true;
        if (string2.charAt(0) == '-') {
            bl = false;
            string2 = string2.substring(1).trim();
        }
        if (!Character.isDigit(string2.charAt(0))) {
            return null;
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Double(bl ? d : -d);
    }

    public static String coerceValueToString(ValueEval valueEval) {
        if (valueEval instanceof StringValueEval) {
            StringValueEval stringValueEval = (StringValueEval)valueEval;
            return stringValueEval.getStringValue();
        }
        if (valueEval instanceof NumberEval) {
            NumberEval numberEval = (NumberEval)valueEval;
            return numberEval.getStringValue();
        }
        if (valueEval instanceof BlankEval) {
            return "";
        }
        throw new IllegalArgumentException("Unexpected eval class (" + valueEval.getClass().getName() + ")");
    }
}

