/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.IntPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NumberPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringValueEval;

public class NumberEval
implements NumericValueEval,
StringValueEval {
    public static final NumberEval ZERO = new NumberEval(0.0);
    private double value;
    private String stringValue;

    public NumberEval(Ptg ptg) {
        if (ptg instanceof IntPtg) {
            this.value = ((IntPtg)ptg).getValue();
        } else if (ptg instanceof NumberPtg) {
            this.value = ((NumberPtg)ptg).getValue();
        }
    }

    public NumberEval(double d) {
        this.value = d;
    }

    public double getNumberValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            this.makeString();
        }
        return this.stringValue;
    }

    protected void makeString() {
        if (!Double.isNaN(this.value)) {
            long l = Math.round(this.value);
            this.stringValue = (double)l == this.value ? String.valueOf(l) : String.valueOf(this.value);
        }
    }
}

