/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NameEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;

final class ExternalFunction
implements FreeRefFunction {
    ExternalFunction() {
    }

    public ValueEval evaluate(Eval[] evalArray, int n, short s, HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet) {
        FreeRefFunction freeRefFunction;
        int n2 = evalArray.length;
        if (n2 < 1) {
            throw new RuntimeException("function name argument missing");
        }
        if (!(evalArray[0] instanceof NameEval)) {
            throw new RuntimeException("First argument should be a NameEval, but got (" + evalArray[0].getClass().getName() + ")");
        }
        NameEval nameEval = (NameEval)evalArray[0];
        int n3 = n2 - 1;
        Eval[] evalArray2 = new Eval[n3];
        System.arraycopy(evalArray, 1, evalArray2, 0, n3);
        try {
            freeRefFunction = this.findTargetFunction(hSSFWorkbook, nameEval);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return freeRefFunction.evaluate(evalArray2, n, s, hSSFWorkbook, hSSFSheet);
    }

    private FreeRefFunction findTargetFunction(HSSFWorkbook hSSFWorkbook, NameEval nameEval) throws EvaluationException {
        int n = hSSFWorkbook.getNumberOfNames();
        int n2 = nameEval.getIndex();
        if (n2 < 0 || n2 >= n) {
            throw new RuntimeException("Bad name index (" + n2 + "). Allowed range is (0.." + (n - 1) + ")");
        }
        String string = hSSFWorkbook.getNameName(n2);
        throw new EvaluationException(ErrorEval.FUNCTION_NOT_IMPLEMENTED);
    }
}

