/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.eval;

import com.fr.third.org.apache.poi.hssf.record.formula.AreaI;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;

abstract class AreaEvalBase
implements AreaEval {
    private final int _firstColumn;
    private final int _firstRow;
    private final int _lastColumn;
    private final int _lastRow;
    private final ValueEval[] _values;
    private final int _nColumns;
    private final int _nRows;

    protected AreaEvalBase(AreaI areaI, ValueEval[] valueEvalArray) {
        if (valueEvalArray == null) {
            throw new IllegalArgumentException("values must not be null");
        }
        this._firstRow = areaI.getFirstRow();
        this._firstColumn = areaI.getFirstColumn();
        this._lastRow = areaI.getLastRow();
        this._lastColumn = areaI.getLastColumn();
        this._nColumns = this._lastColumn - this._firstColumn + 1;
        this._nRows = this._lastRow - this._firstRow + 1;
        int n = this._nRows * this._nColumns;
        if (valueEvalArray.length != n) {
            throw new IllegalArgumentException("Array size should be (" + n + ") but was (" + valueEvalArray.length + ")");
        }
        for (int i = valueEvalArray.length - 1; i >= 0; --i) {
            if (valueEvalArray[i] != null) continue;
            throw new IllegalArgumentException("value array elements must not be null");
        }
        this._values = valueEvalArray;
    }

    public final int getFirstColumn() {
        return this._firstColumn;
    }

    public final int getFirstRow() {
        return this._firstRow;
    }

    public final int getLastColumn() {
        return this._lastColumn;
    }

    public final int getLastRow() {
        return this._lastRow;
    }

    public final ValueEval[] getValues() {
        return this._values;
    }

    public final ValueEval getValueAt(int n, int n2) {
        int n3 = n - this._firstRow;
        int n4 = n2 - this._firstColumn;
        if (n3 < 0 || n3 >= this._nRows) {
            throw new IllegalArgumentException("Specified row index (" + n + ") is outside the allowed range (" + this._firstRow + ".." + this._lastRow + ")");
        }
        if (n4 < 0 || n4 >= this._nColumns) {
            throw new IllegalArgumentException("Specified column index (" + n2 + ") is outside the allowed range (" + this._firstColumn + ".." + n2 + ")");
        }
        int n5 = n3 * this._nColumns + n4;
        return this._values[n5];
    }

    public final boolean contains(int n, int n2) {
        return this._firstRow <= n && this._lastRow >= n && this._firstColumn <= n2 && this._lastColumn >= n2;
    }

    public final boolean containsRow(int n) {
        return this._firstRow <= n && this._lastRow >= n;
    }

    public final boolean containsColumn(short s) {
        return this._firstColumn <= s && this._lastColumn >= s;
    }

    public final boolean isColumn() {
        return this._firstColumn == this._lastColumn;
    }

    public final boolean isRow() {
        return this._firstRow == this._lastRow;
    }
}

