/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.StringUtil;

public final class StringPtg
extends ScalarConstantPtg {
    public static final int SIZE = 9;
    public static final byte sid = 23;
    private static final BitField fHighByte = BitFieldFactory.getInstance(1);
    private static final char FORMULA_DELIMITER = '\"';
    private final int field_1_length;
    private final byte field_2_options;
    private final String field_3_string;

    public StringPtg(RecordInputStream recordInputStream) {
        this.field_1_length = recordInputStream.readUByte();
        this.field_2_options = recordInputStream.readByte();
        this.field_3_string = fHighByte.isSet(this.field_2_options) ? recordInputStream.readUnicodeLEString(this.field_1_length) : recordInputStream.readCompressedUnicode(this.field_1_length);
    }

    public StringPtg(String string) {
        if (string.length() > 255) {
            throw new IllegalArgumentException("String literals in formulas can't be bigger than 255 characters ASCII");
        }
        this.field_2_options = (byte)fHighByte.setBoolean(0, StringUtil.hasMultibyte(string));
        this.field_3_string = string;
        this.field_1_length = string.length();
    }

    public String getValue() {
        return this.field_3_string;
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = 23;
        byArray[n + 1] = (byte)this.field_1_length;
        byArray[n + 2] = this.field_2_options;
        if (fHighByte.isSet(this.field_2_options)) {
            StringUtil.putUnicodeLE(this.getValue(), byArray, n + 3);
        } else {
            StringUtil.putCompressedUnicode(this.getValue(), byArray, n + 3);
        }
    }

    public int getSize() {
        if (fHighByte.isSet(this.field_2_options)) {
            return 2 * this.field_1_length + 3;
        }
        return this.field_1_length + 3;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        String string = this.field_3_string;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\"');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.field_3_string);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

