/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SheetNameFormatter {
    private static final String BIFF8_LAST_COLUMN = "IV";
    private static final int BIFF8_LAST_COLUMN_TEXT_LEN = "IV".length();
    private static final String BIFF8_LAST_ROW = String.valueOf(65536);
    private static final int BIFF8_LAST_ROW_TEXT_LEN = BIFF8_LAST_ROW.length();
    private static final char DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Za-z])+[0-9]+");

    private SheetNameFormatter() {
    }

    public static String format(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        SheetNameFormatter.appendFormat(stringBuffer, string);
        return stringBuffer.toString();
    }

    public static void appendFormat(StringBuffer stringBuffer, String string) {
        boolean bl = SheetNameFormatter.needsDelimiting(string);
        if (bl) {
            stringBuffer.append('\'');
            SheetNameFormatter.appendAndEscape(stringBuffer, string);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append(string);
        }
    }

    private static void appendAndEscape(StringBuffer stringBuffer, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(c);
        }
    }

    private static boolean needsDelimiting(String string) {
        int n = string.length();
        if (n < 1) {
            throw new RuntimeException("Zero length string is an invalid sheet name");
        }
        if (Character.isDigit(string.charAt(0))) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!SheetNameFormatter.isSpecialChar(c)) continue;
            return true;
        }
        return Character.isLetter(string.charAt(0)) && Character.isDigit(string.charAt(n - 1)) && SheetNameFormatter.nameLooksLikePlainCellReference(string);
    }

    static boolean isSpecialChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return false;
        }
        switch (c) {
            case '_': {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                throw new RuntimeException("Illegal character (0x" + Integer.toHexString(c) + ") found in sheet name");
            }
        }
        return true;
    }

    static boolean cellReferenceIsWithinRange(String string, int n) {
        String string2;
        if (n > BIFF8_LAST_COLUMN_TEXT_LEN) {
            return false;
        }
        int n2 = string.length() - n;
        if (n2 > BIFF8_LAST_ROW_TEXT_LEN) {
            return false;
        }
        if (n == BIFF8_LAST_COLUMN_TEXT_LEN && (string2 = string.substring(0, BIFF8_LAST_COLUMN_TEXT_LEN).toUpperCase()).compareTo(BIFF8_LAST_COLUMN) > 0) {
            return false;
        }
        return n2 != BIFF8_LAST_ROW_TEXT_LEN || (string2 = string.substring(n)).compareTo(BIFF8_LAST_ROW) <= 0;
    }

    static boolean nameLooksLikePlainCellReference(String string) {
        Matcher matcher = CELL_REF_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        String string2 = matcher.group(1);
        return SheetNameFormatter.cellReferenceIsWithinRange(string, string2.length());
    }
}

