/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public abstract class RefPtgBase
extends OperandPtg {
    private static final int SIZE = 5;
    private static final int MAX_ROW_NUMBER = 65536;
    private int field_1_row;
    private int field_2_col;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField column = BitFieldFactory.getInstance(255);

    protected RefPtgBase() {
    }

    protected RefPtgBase(String string) {
        CellReference cellReference = new CellReference(string);
        this.setRow(cellReference.getRow());
        this.setColumn(cellReference.getCol());
        this.setColRelative(!cellReference.isColAbsolute());
        this.setRowRelative(!cellReference.isRowAbsolute());
    }

    protected RefPtgBase(int n, int n2, boolean bl, boolean bl2) {
        this.setRow(n);
        this.setColumn(n2);
        this.setRowRelative(bl);
        this.setColRelative(bl2);
    }

    protected RefPtgBase(RecordInputStream recordInputStream) {
        this.field_1_row = recordInputStream.readUShort();
        this.field_2_col = recordInputStream.readUShort();
    }

    public final String toString() {
        CellReference cellReference = new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append(cellReference.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final void writeBytes(byte[] byArray, int n) {
        byArray[n] = (byte)(this.getSid() + this.getPtgClass());
        LittleEndian.putShort(byArray, n + 1, (short)this.field_1_row);
        LittleEndian.putShort(byArray, n + 3, (short)this.field_2_col);
    }

    protected abstract byte getSid();

    public final void setRow(int n) {
        if (n < 0 || n >= 65536) {
            throw new IllegalArgumentException("The row number, when specified as an integer, must be between 0 and 65536");
        }
        this.field_1_row = n;
    }

    public final int getRow() {
        return this.field_1_row;
    }

    public final int getRowAsInt() {
        return this.field_1_row;
    }

    public final boolean isRowRelative() {
        return rowRelative.isSet(this.field_2_col);
    }

    public final void setRowRelative(boolean bl) {
        this.field_2_col = rowRelative.setBoolean(this.field_2_col, bl);
    }

    public final boolean isColRelative() {
        return colRelative.isSet(this.field_2_col);
    }

    public final void setColRelative(boolean bl) {
        this.field_2_col = colRelative.setBoolean(this.field_2_col, bl);
    }

    public final void setColumnRawX(int n) {
        this.field_2_col = n;
    }

    public int getColumnRawX() {
        return this.field_2_col;
    }

    public final void setColumn(int n) {
        if (n < 0 || n >= 256) {
            throw new IllegalArgumentException("Specified colIx (" + n + ") is out of range");
        }
        this.field_2_col = column.setValue(this.field_2_col, n);
    }

    public final int getColumn() {
        return column.getValue(this.field_2_col);
    }

    public final int getSize() {
        return 5;
    }

    public final String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return new CellReference(this.getRowAsInt(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).formatAsString();
    }

    public final byte getDefaultOperandClass() {
        return 0;
    }
}

