/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class RefErrorPtg
extends OperandPtg {
    private static final int SIZE = 5;
    public static final byte sid = 42;
    private int field_1_reserved;

    public RefErrorPtg(RecordInputStream recordInputStream) {
        this.field_1_reserved = recordInputStream.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[RefError]\n");
        stringBuffer.append("reserved = ").append(this.getReserved()).append("\n");
        return stringBuffer.toString();
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n] = (byte)(42 + this.getPtgClass());
        LittleEndian.putInt(byArray, n + 1, this.field_1_reserved);
    }

    public void setReserved(int n) {
        this.field_1_reserved = n;
    }

    public int getReserved() {
        return this.field_1_reserved;
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return "#REF!";
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

