/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.SheetNameFormatter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.hssf.util.RangeAddress;
import com.fr.third.org.apache.poi.hssf.util.SheetReferences;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class Ref3DPtg
extends OperandPtg {
    public static final byte sid = 58;
    private static final int SIZE = 7;
    private short field_1_index_extern_sheet;
    private int field_2_row;
    private int field_3_column;
    private BitField rowRelative = BitFieldFactory.getInstance(32768);
    private BitField colRelative = BitFieldFactory.getInstance(16384);

    public Ref3DPtg() {
    }

    public Ref3DPtg(RecordInputStream recordInputStream) {
        this.field_1_index_extern_sheet = recordInputStream.readShort();
        this.field_2_row = recordInputStream.readShort();
        this.field_3_column = recordInputStream.readShort();
    }

    public Ref3DPtg(String string, short s) {
        CellReference cellReference = new CellReference(string);
        this.setRow(cellReference.getRow());
        this.setColumn(cellReference.getCol());
        this.setColRelative(!cellReference.isColAbsolute());
        this.setRowRelative(!cellReference.isRowAbsolute());
        this.setExternSheetIndex(s);
    }

    public String toString() {
        CellReference cellReference = new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append("sheetIx=").append(this.getExternSheetIndex());
        stringBuffer.append(" ! ");
        stringBuffer.append(cellReference.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[0 + n] = (byte)(58 + this.getPtgClass());
        LittleEndian.putShort(byArray, 1 + n, this.getExternSheetIndex());
        LittleEndian.putShort(byArray, 3 + n, (short)this.getRow());
        LittleEndian.putShort(byArray, 5 + n, (short)this.getColumnRaw());
    }

    public int getSize() {
        return 7;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short s) {
        this.field_1_index_extern_sheet = s;
    }

    public int getRow() {
        return this.field_2_row;
    }

    public void setRow(int n) {
        this.field_2_row = n;
    }

    public int getColumn() {
        return this.field_3_column & 0xFF;
    }

    public int getColumnRaw() {
        return this.field_3_column;
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_3_column);
    }

    public void setRowRelative(boolean bl) {
        this.field_3_column = this.rowRelative.setBoolean(this.field_3_column, bl);
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_3_column);
    }

    public void setColRelative(boolean bl) {
        this.field_3_column = this.colRelative.setBoolean(this.field_3_column, bl);
    }

    public void setColumn(short s) {
        this.field_3_column &= 0xFF00;
        this.field_3_column |= s & 0xFF;
    }

    public void setColumnRaw(short s) {
        this.field_3_column = s;
    }

    public void setArea(String string) {
        RangeAddress rangeAddress = new RangeAddress(string);
        String string2 = rangeAddress.getFromCell();
        this.setColumn((short)(rangeAddress.getXPosition(string2) - 1));
        this.setRow((short)(rangeAddress.getYPosition(string2) - 1));
    }

    static String getSheetName(HSSFWorkbook hSSFWorkbook, int n) {
        if (hSSFWorkbook == null) {
            return null;
        }
        SheetReferences sheetReferences = hSSFWorkbook.getSheetReferences();
        if (sheetReferences == null) {
            return null;
        }
        return sheetReferences.getSheetName(n);
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Ref3DPtg.getSheetName(hSSFWorkbook, this.field_1_index_extern_sheet);
        if (string != null) {
            SheetNameFormatter.appendFormat(stringBuffer, string);
            stringBuffer.append('!');
        }
        stringBuffer.append(new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).formatAsString());
        return stringBuffer.toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

