/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AddPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Area3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaErrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaNPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ArrayPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AttrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.BoolPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ConcatPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.DeletedArea3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.DeletedRef3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.DividePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.EqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ErrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ExpPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.FuncVarPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.GreaterThanPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.IntPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.IntersectionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.LessEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.LessThanPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemAreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemErrPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MemFuncPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MissingArgPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.MultiplyPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NamePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NameXPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NotEqualPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.NumberPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ParenthesisPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.PercentPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.PowerPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RangePtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefErrorPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefNPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.StringPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.SubtractPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.UnknownPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.ValueOperatorPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.HexDump;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class Ptg
implements Cloneable {
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    private byte ptgClass = 0;

    public static Ptg[] readTokens(int n, RecordInputStream recordInputStream) {
        Stack stack = Ptg.createParsedExpressionTokens((short)n, recordInputStream);
        return Ptg.toPtgArray(stack);
    }

    public static Stack createParsedExpressionTokens(short n, RecordInputStream recordInputStream) {
        Stack<Ptg> stack = new Stack<Ptg>();
        int n2 = 0;
        ArrayList<Ptg> arrayList = null;
        while (n2 < n) {
            Ptg ptg = Ptg.createPtg(recordInputStream);
            if (ptg instanceof ArrayPtg) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Ptg>(5);
                }
                arrayList.add(ptg);
                n2 += 8;
            } else {
                n2 += ptg.getSize();
            }
            stack.push(ptg);
        }
        if (n2 != n) {
            throw new RuntimeException("Ptg array size mismatch");
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayPtg arrayPtg = (ArrayPtg)arrayList.get(i);
                arrayPtg.readTokenValues(recordInputStream);
            }
        }
        return stack;
    }

    public static Ptg createPtg(RecordInputStream recordInputStream) {
        byte by = recordInputStream.readByte();
        if (by < 32) {
            return Ptg.createBasePtg(by, recordInputStream);
        }
        Ptg ptg = Ptg.createClassifiedPtg(by, recordInputStream);
        if (by > 96) {
            ptg.setClass((byte)64);
        } else if (by > 64) {
            ptg.setClass((byte)32);
        } else {
            ptg.setClass((byte)0);
        }
        return ptg;
    }

    private static Ptg createClassifiedPtg(byte by, RecordInputStream recordInputStream) {
        int n = by & 0x1F | 0x20;
        switch (n) {
            case 32: {
                return new ArrayPtg(recordInputStream);
            }
            case 33: {
                return new FuncPtg(recordInputStream);
            }
            case 34: {
                return new FuncVarPtg(recordInputStream);
            }
            case 35: {
                return new NamePtg(recordInputStream);
            }
            case 36: {
                return new RefPtg(recordInputStream);
            }
            case 37: {
                return new AreaPtg(recordInputStream);
            }
            case 38: {
                return new MemAreaPtg(recordInputStream);
            }
            case 39: {
                return new MemErrPtg(recordInputStream);
            }
            case 41: {
                return new MemFuncPtg(recordInputStream);
            }
            case 42: {
                return new RefErrorPtg(recordInputStream);
            }
            case 43: {
                return new AreaErrPtg(recordInputStream);
            }
            case 44: {
                return new RefNPtg(recordInputStream);
            }
            case 45: {
                return new AreaNPtg(recordInputStream);
            }
            case 57: {
                return new NameXPtg(recordInputStream);
            }
            case 58: {
                return new Ref3DPtg(recordInputStream);
            }
            case 59: {
                return new Area3DPtg(recordInputStream);
            }
            case 60: {
                return new DeletedRef3DPtg(recordInputStream);
            }
            case 61: {
                return new DeletedArea3DPtg(recordInputStream);
            }
        }
        throw new UnsupportedOperationException(" Unknown Ptg in Formula: 0x" + Integer.toHexString(by) + " (" + by + ")");
    }

    private static Ptg createBasePtg(byte by, RecordInputStream recordInputStream) {
        switch (by) {
            case 0: {
                return new UnknownPtg();
            }
            case 1: {
                return new ExpPtg(recordInputStream);
            }
            case 3: {
                return AddPtg.instance;
            }
            case 4: {
                return SubtractPtg.instance;
            }
            case 5: {
                return MultiplyPtg.instance;
            }
            case 6: {
                return DividePtg.instance;
            }
            case 7: {
                return PowerPtg.instance;
            }
            case 8: {
                return ConcatPtg.instance;
            }
            case 9: {
                return LessThanPtg.instance;
            }
            case 10: {
                return LessEqualPtg.instance;
            }
            case 11: {
                return EqualPtg.instance;
            }
            case 12: {
                return GreaterEqualPtg.instance;
            }
            case 13: {
                return GreaterThanPtg.instance;
            }
            case 14: {
                return NotEqualPtg.instance;
            }
            case 15: {
                return IntersectionPtg.instance;
            }
            case 16: {
                return UnionPtg.instance;
            }
            case 17: {
                return RangePtg.instance;
            }
            case 18: {
                return UnaryPlusPtg.instance;
            }
            case 19: {
                return UnaryMinusPtg.instance;
            }
            case 20: {
                return PercentPtg.instance;
            }
            case 21: {
                return ParenthesisPtg.instance;
            }
            case 22: {
                return MissingArgPtg.instance;
            }
            case 23: {
                return new StringPtg(recordInputStream);
            }
            case 25: 
            case 26: {
                return new AttrPtg(recordInputStream);
            }
            case 28: {
                return new ErrPtg(recordInputStream);
            }
            case 29: {
                return new BoolPtg(recordInputStream);
            }
            case 30: {
                return new IntPtg(recordInputStream);
            }
            case 31: {
                return new NumberPtg(recordInputStream);
            }
        }
        throw new RuntimeException("Unexpected base token id (" + by + ")");
    }

    public static int getEncodedSize(Stack stack) {
        return Ptg.getEncodedSize(Ptg.toPtgArray(stack));
    }

    public final Ptg copy() {
        if (this instanceof ValueOperatorPtg) {
            return this;
        }
        if (this instanceof ScalarConstantPtg) {
            return this;
        }
        return (Ptg)this.clone();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    private static Ptg[] toPtgArray(List list) {
        Ptg[] ptgArray = new Ptg[list.size()];
        list.toArray(ptgArray);
        return ptgArray;
    }

    private static Stack createStack(Ptg[] ptgArray) {
        Stack<Ptg> stack = new Stack<Ptg>();
        for (int i = 0; i < ptgArray.length; ++i) {
            stack.add(ptgArray[i]);
        }
        return stack;
    }

    public static int getEncodedSize(Ptg[] ptgArray) {
        int n = 0;
        for (int i = 0; i < ptgArray.length; ++i) {
            n += ptgArray[i].getSize();
        }
        return n;
    }

    public static int serializePtgs(Ptg[] ptgArray, byte[] byArray, int n) {
        return Ptg.serializePtgStack(Ptg.createStack(ptgArray), byArray, n);
    }

    public static int serializePtgStack(Stack stack, byte[] byArray, int n) {
        Ptg ptg;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (stack != null) {
            n4 = stack.size();
        }
        ArrayList<Ptg> arrayList = null;
        for (n2 = 0; n2 < n4; ++n2) {
            ptg = (Ptg)stack.get(n2);
            ptg.writeBytes(byArray, n3 + n);
            if (ptg instanceof ArrayPtg) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Ptg>(5);
                }
                arrayList.add(ptg);
                n3 += 8;
                continue;
            }
            n3 += ptg.getSize();
        }
        if (arrayList != null) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ptg = (ArrayPtg)arrayList.get(n2);
                n3 += ((ArrayPtg)ptg).writeTokenValueBytes(byArray, n3 + n);
            }
        }
        return n3;
    }

    public abstract int getSize();

    public final byte[] getBytes() {
        int n = this.getSize();
        byte[] byArray = new byte[n];
        this.writeBytes(byArray, 0);
        return byArray;
    }

    public abstract void writeBytes(byte[] var1, int var2);

    public abstract String toFormulaString(HSSFWorkbook var1);

    public final String toDebugString() {
        byte[] byArray = new byte[this.getSize()];
        String string = null;
        this.writeBytes(byArray, 0);
        try {
            string = HexDump.dump(byArray, 0L, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String toString() {
        return this.getClass().toString();
    }

    public final void setClass(byte by) {
        if (this.isBaseToken()) {
            throw new RuntimeException("setClass should not be called on a base token");
        }
        this.ptgClass = by;
    }

    public final byte getPtgClass() {
        return this.ptgClass;
    }

    public abstract byte getDefaultOperandClass();

    public abstract boolean isBaseToken();
}

