/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class NameXPtg
extends OperandPtg {
    public static final short sid = 57;
    private static final int SIZE = 7;
    private short field_1_ixals;
    private short field_2_ilbl;
    private short field_3_reserved;

    public NameXPtg(RecordInputStream recordInputStream) {
        this.field_1_ixals = recordInputStream.readShort();
        this.field_2_ilbl = recordInputStream.readShort();
        this.field_3_reserved = recordInputStream.readShort();
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = (byte)(57 + this.getPtgClass());
        LittleEndian.putShort(byArray, n + 1, this.field_1_ixals);
        LittleEndian.putShort(byArray, n + 3, this.field_2_ilbl);
        LittleEndian.putShort(byArray, n + 5, this.field_3_reserved);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return hSSFWorkbook.resolveNameXText(this.field_1_ixals, this.field_2_ilbl - 1);
    }

    public byte getDefaultOperandClass() {
        return 32;
    }
}

