/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFName;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class NamePtg
extends OperandPtg {
    public static final short sid = 35;
    private static final int SIZE = 5;
    private short field_1_label_index;
    private short field_2_zero;

    public NamePtg(String string, HSSFWorkbook hSSFWorkbook) {
        this.field_1_label_index = (short)(1 + NamePtg.getOrCreateNameRecord(hSSFWorkbook, string));
    }

    private static final int getOrCreateNameRecord(HSSFWorkbook hSSFWorkbook, String string) {
        int n = hSSFWorkbook.getNumberOfNames();
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(hSSFWorkbook.getNameName(i))) continue;
            return i;
        }
        HSSFName hSSFName = hSSFWorkbook.createName();
        hSSFName.setNameName(string);
        return n;
    }

    public NamePtg(RecordInputStream recordInputStream) {
        this.field_1_label_index = recordInputStream.readShort();
        this.field_2_zero = recordInputStream.readShort();
    }

    public int getIndex() {
        return this.field_1_label_index - 1;
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = (byte)(35 + this.getPtgClass());
        LittleEndian.putShort(byArray, n + 1, this.field_1_label_index);
        LittleEndian.putShort(byArray, n + 3, this.field_2_zero);
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return hSSFWorkbook.getNameName(this.field_1_label_index - 1);
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

