/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class MemAreaPtg
extends OperandPtg {
    public static final short sid = 38;
    private static final int SIZE = 7;
    private int field_1_reserved;
    private short field_2_subex_len;

    public MemAreaPtg() {
    }

    public MemAreaPtg(RecordInputStream recordInputStream) {
        this.field_1_reserved = recordInputStream.readInt();
        this.field_2_subex_len = recordInputStream.readShort();
    }

    public void setReserved(int n) {
        this.field_1_reserved = n;
    }

    public int getReserved() {
        return this.field_1_reserved;
    }

    public void setSubexpressionLength(short s) {
        this.field_2_subex_len = s;
    }

    public short getSubexpressionLength() {
        return this.field_2_subex_len;
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n] = (byte)(38 + this.getPtgClass());
        LittleEndian.putInt(byArray, n + 1, this.field_1_reserved);
        LittleEndian.putShort(byArray, n + 5, this.field_2_subex_len);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return "";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }
}

