/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.ScalarConstantPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class IntPtg
extends ScalarConstantPtg {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private final int field_1_value;

    public static boolean isInRange(int n) {
        return n >= 0 && n <= 65535;
    }

    public IntPtg(RecordInputStream recordInputStream) {
        this(recordInputStream.readUShort());
    }

    public IntPtg(int n) {
        if (!IntPtg.isInRange(n)) {
            throw new IllegalArgumentException("value is out of range: " + n);
        }
        this.field_1_value = n;
    }

    public int getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = 30;
        LittleEndian.putUShort(byArray, n + 1, this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return String.valueOf(this.getValue());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.field_1_value);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

