/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class FuncVarPtg
extends AbstractFunctionPtg {
    public static final byte sid = 34;
    private static final int SIZE = 4;

    public FuncVarPtg(RecordInputStream recordInputStream) {
        this.field_1_num_args = recordInputStream.readByte();
        this.field_2_fnc_index = recordInputStream.readShort();
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(this.field_2_fnc_index);
        if (functionMetadata == null) {
            this.returnClass = (byte)32;
            this.paramClass = new byte[]{32};
        } else {
            this.returnClass = functionMetadata.getReturnClassCode();
            this.paramClass = functionMetadata.getParameterClassCodes();
        }
    }

    public FuncVarPtg(String string, byte by) {
        this.field_1_num_args = by;
        this.field_2_fnc_index = FuncVarPtg.lookupIndex(string);
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(this.field_2_fnc_index);
        if (functionMetadata == null) {
            this.returnClass = (byte)32;
            this.paramClass = new byte[]{32};
        } else {
            this.returnClass = functionMetadata.getReturnClassCode();
            this.paramClass = functionMetadata.getParameterClassCodes();
        }
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = (byte)(34 + this.getPtgClass());
        byArray[n + 1] = this.field_1_num_args;
        LittleEndian.putShort(byArray, n + 2, this.field_2_fnc_index);
    }

    public int getNumberOfOperands() {
        return this.field_1_num_args;
    }

    public int getSize() {
        return 4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.lookupName(this.field_2_fnc_index));
        stringBuffer.append(" nArgs=").append(this.field_1_num_args);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

