/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class FuncPtg
extends AbstractFunctionPtg {
    public static final byte sid = 33;
    public static final int SIZE = 3;
    private int numParams = 0;

    public FuncPtg(RecordInputStream recordInputStream) {
        this.field_2_fnc_index = recordInputStream.readShort();
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(this.field_2_fnc_index);
        if (functionMetadata == null) {
            throw new RuntimeException("Invalid built-in function index (" + this.field_2_fnc_index + ")");
        }
        this.numParams = functionMetadata.getMinParams();
        this.returnClass = functionMetadata.getReturnClassCode();
        this.paramClass = functionMetadata.getParameterClassCodes();
    }

    public FuncPtg(int n) {
        this.field_2_fnc_index = (short)n;
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(n);
        this.numParams = functionMetadata.getMinParams();
        this.returnClass = functionMetadata.getReturnClassCode();
        this.paramClass = functionMetadata.getParameterClassCodes();
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = (byte)(33 + this.getPtgClass());
        LittleEndian.putShort(byArray, n + 1, this.field_2_fnc_index);
    }

    public int getNumberOfOperands() {
        return this.numParams;
    }

    public int getSize() {
        return 3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.lookupName(this.field_2_fnc_index));
        stringBuffer.append(" nArgs=").append(this.numParams);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

