/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.ControlPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class ExpPtg
extends ControlPtg {
    private static final int SIZE = 5;
    public static final short sid = 1;
    private final short field_1_first_row;
    private final short field_2_first_col;

    public ExpPtg(RecordInputStream recordInputStream) {
        this.field_1_first_row = recordInputStream.readShort();
        this.field_2_first_col = recordInputStream.readShort();
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[n + 0] = 1;
        LittleEndian.putShort(byArray, n + 1, this.field_1_first_row);
        LittleEndian.putShort(byArray, n + 3, this.field_2_first_col);
    }

    public int getSize() {
        return 5;
    }

    public short getRow() {
        return this.field_1_first_row;
    }

    public short getColumn() {
        return this.field_2_first_col;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        throw new RecordFormatException("Coding Error: Expected ExpPtg to be converted from Shared to Non-Shared Formula by ValueRecordsAggregate, but it wasn't");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Array Formula or Shared Formula]\n");
        stringBuffer.append("row = ").append(this.getRow()).append("\n");
        stringBuffer.append("col = ").append(this.getColumn()).append("\n");
        return stringBuffer.toString();
    }
}

