/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.ControlPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class AttrPtg
extends ControlPtg {
    public static final byte sid = 25;
    private static final int SIZE = 4;
    private byte field_1_options;
    private short field_2_data;
    private final int[] _jumpTable;
    private final int _chooseFuncOffset;
    private static final BitField semiVolatile = BitFieldFactory.getInstance(1);
    private static final BitField optiIf = BitFieldFactory.getInstance(2);
    private static final BitField optiChoose = BitFieldFactory.getInstance(4);
    private static final BitField optGoto = BitFieldFactory.getInstance(8);
    private static final BitField sum = BitFieldFactory.getInstance(16);
    private static final BitField baxcel = BitFieldFactory.getInstance(32);
    private static final BitField space = BitFieldFactory.getInstance(64);

    public AttrPtg() {
        this._jumpTable = null;
        this._chooseFuncOffset = -1;
    }

    public AttrPtg(RecordInputStream recordInputStream) {
        this.field_1_options = recordInputStream.readByte();
        this.field_2_data = recordInputStream.readShort();
        if (this.isOptimizedChoose()) {
            short s = this.field_2_data;
            int[] nArray = new int[s];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = recordInputStream.readUShort();
            }
            this._jumpTable = nArray;
            this._chooseFuncOffset = recordInputStream.readUShort();
        } else {
            this._jumpTable = null;
            this._chooseFuncOffset = -1;
        }
    }

    private AttrPtg(int n, int n2, int[] nArray, int n3) {
        this.field_1_options = (byte)n;
        this.field_2_data = (short)n2;
        this._jumpTable = nArray;
        this._chooseFuncOffset = n3;
    }

    public static AttrPtg createSpace(int n, int n2) {
        int n3 = n & 0xFF | n2 << 8 & 0xFFFF;
        return new AttrPtg(space.set(0), n3, null, -1);
    }

    public void setOptions(byte by) {
        this.field_1_options = by;
    }

    public byte getOptions() {
        return this.field_1_options;
    }

    public boolean isSemiVolatile() {
        return semiVolatile.isSet(this.getOptions());
    }

    public boolean isOptimizedIf() {
        return optiIf.isSet(this.getOptions());
    }

    public boolean isOptimizedChoose() {
        return optiChoose.isSet(this.getOptions());
    }

    public boolean isGoto() {
        return optGoto.isSet(this.getOptions());
    }

    public boolean isSum() {
        return sum.isSet(this.getOptions());
    }

    public void setSum(boolean bl) {
        this.field_1_options = sum.setByteBoolean(this.field_1_options, bl);
    }

    public void setOptimizedIf(boolean bl) {
        this.field_1_options = optiIf.setByteBoolean(this.field_1_options, bl);
    }

    public void setGoto(boolean bl) {
        this.field_1_options = optGoto.setByteBoolean(this.field_1_options, bl);
    }

    public boolean isBaxcel() {
        return baxcel.isSet(this.getOptions());
    }

    public boolean isSpace() {
        return space.isSet(this.getOptions());
    }

    public void setData(short s) {
        this.field_2_data = s;
    }

    public short getData() {
        return this.field_2_data;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        if (this.isSemiVolatile()) {
            stringBuffer.append("volatile ");
        }
        if (this.isSpace()) {
            stringBuffer.append("space count=").append(this.field_2_data >> 8 & 0xFF);
            stringBuffer.append(" type=").append(this.field_2_data & 0xFF).append(" ");
        }
        if (this.isOptimizedIf()) {
            stringBuffer.append("if dist=").append(this.getData());
        } else if (this.isOptimizedChoose()) {
            stringBuffer.append("choose nCases=").append(this.getData());
        } else if (this.isGoto()) {
            stringBuffer.append("skip dist=").append(this.getData());
        } else if (this.isSum()) {
            stringBuffer.append("sum ");
        } else if (this.isBaxcel()) {
            stringBuffer.append("assign ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void writeBytes(byte[] byArray, int n) {
        LittleEndian.putByte(byArray, n + 0, 25);
        LittleEndian.putByte(byArray, n + 1, this.field_1_options);
        LittleEndian.putShort(byArray, n + 2, this.field_2_data);
        int[] nArray = this._jumpTable;
        if (nArray != null) {
            int n2 = n + 4;
            LittleEndian.putUShort(byArray, n2, this._chooseFuncOffset);
            n2 += 2;
            for (int i = 0; i < nArray.length; ++i) {
                LittleEndian.putUShort(byArray, n2, nArray[i]);
                n2 += 2;
            }
            LittleEndian.putUShort(byArray, n2, this._chooseFuncOffset);
        }
    }

    public int getSize() {
        if (this._jumpTable != null) {
            return 4 + (this._jumpTable.length + 1) * 2;
        }
        return 4;
    }

    public String toFormulaString(String[] stringArray) {
        if (space.isSet(this.field_1_options)) {
            return stringArray[0];
        }
        if (optiIf.isSet(this.field_1_options)) {
            return this.toFormulaString((HSSFWorkbook)null) + "(" + stringArray[0] + ")";
        }
        if (optGoto.isSet(this.field_1_options)) {
            return this.toFormulaString((HSSFWorkbook)null) + stringArray[0];
        }
        return this.toFormulaString((HSSFWorkbook)null) + "(" + stringArray[0] + ")";
    }

    public int getNumberOfOperands() {
        return 1;
    }

    public int getType() {
        return -1;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        if (semiVolatile.isSet(this.field_1_options)) {
            return "ATTR(semiVolatile)";
        }
        if (optiIf.isSet(this.field_1_options)) {
            return "IF";
        }
        if (optiChoose.isSet(this.field_1_options)) {
            return "CHOOSE";
        }
        if (optGoto.isSet(this.field_1_options)) {
            return "";
        }
        if (sum.isSet(this.field_1_options)) {
            return "SUM";
        }
        if (baxcel.isSet(this.field_1_options)) {
            return "ATTR(baxcel)";
        }
        if (space.isSet(this.field_1_options)) {
            return "";
        }
        return "UNKNOWN ATTRIBUTE";
    }

    public Object clone() {
        int[] nArray = this._jumpTable == null ? null : (int[])this._jumpTable.clone();
        return new AttrPtg(this.field_1_options, this.field_2_data, nArray, this._chooseFuncOffset);
    }

    public static final class SpaceType {
        public static final int SPACE_BEFORE = 0;
        public static final int CR_BEFORE = 1;
        public static final int SPACE_BEFORE_OPEN_PAREN = 2;
        public static final int CR_BEFORE_OPEN_PAREN = 3;
        public static final int SPACE_BEFORE_CLOSE_PAREN = 4;
        public static final int CR_BEFORE_CLOSE_PAREN = 5;
        public static final int SPACE_AFTER_EQUALITY = 6;

        private SpaceType() {
        }
    }
}

