/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.hssf.record.constant.ConstantValueParser;
import com.fr.third.org.apache.poi.hssf.record.constant.ErrorConstant;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class ArrayPtg
extends Ptg {
    public static final byte sid = 32;
    private static final int RESERVED_FIELD_LEN = 7;
    private byte[] field_1_reserved = new byte[7];
    private short token_1_columns;
    private short token_2_rows;
    private Object[] token_3_arrayValues;

    public ArrayPtg(RecordInputStream recordInputStream) {
        for (int i = 0; i < 7; ++i) {
            this.field_1_reserved[i] = recordInputStream.readByte();
        }
    }

    public Object[] getTokenArrayValues() {
        return (Object[])this.token_3_arrayValues.clone();
    }

    public boolean isBaseToken() {
        return false;
    }

    public void readTokenValues(RecordInputStream recordInputStream) {
        short s = recordInputStream.readUByte();
        short s2 = recordInputStream.readShort();
        s = (short)(s + 1);
        s2 = (short)(s2 + 1);
        this.token_1_columns = s;
        this.token_2_rows = s2;
        int n = s2 * s;
        this.token_3_arrayValues = ConstantValueParser.parse(recordInputStream, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ArrayPtg]\n");
        stringBuffer.append("columns = ").append(this.getColumnCount()).append("\n");
        stringBuffer.append("rows = ").append(this.getRowCount()).append("\n");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                Object object = this.token_3_arrayValues[this.getValueIndex(i, j)];
                stringBuffer.append("[").append(i).append("][").append(j).append("] = ").append(object).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    int getValueIndex(int n, int n2) {
        if (n < 0 || n >= this.token_1_columns) {
            throw new IllegalArgumentException("Specified colIx (" + n + ") is outside the allowed range (0.." + (this.token_1_columns - 1) + ")");
        }
        if (n2 < 0 || n2 >= this.token_2_rows) {
            throw new IllegalArgumentException("Specified rowIx (" + n2 + ") is outside the allowed range (0.." + (this.token_2_rows - 1) + ")");
        }
        return n2 + this.token_2_rows * n;
    }

    public void writeBytes(byte[] byArray, int n) {
        LittleEndian.putByte(byArray, n + 0, 32 + this.getPtgClass());
        System.arraycopy(this.field_1_reserved, 0, byArray, n + 1, 7);
    }

    public int writeTokenValueBytes(byte[] byArray, int n) {
        LittleEndian.putByte(byArray, n + 0, this.token_1_columns - 1);
        LittleEndian.putShort(byArray, n + 1, (short)(this.token_2_rows - 1));
        ConstantValueParser.encode(byArray, n + 3, this.token_3_arrayValues);
        return 3 + ConstantValueParser.getEncodedSize(this.token_3_arrayValues);
    }

    public short getRowCount() {
        return this.token_2_rows;
    }

    public short getColumnCount() {
        return this.token_1_columns;
    }

    public int getSize() {
        int n = 11;
        return n += ConstantValueParser.getEncodedSize(this.token_3_arrayValues);
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(";");
            }
            for (int j = 0; j < this.getRowCount(); ++j) {
                if (j > 0) {
                    stringBuffer.append(",");
                }
                Object object = this.token_3_arrayValues[this.getValueIndex(i, j)];
                stringBuffer.append(ArrayPtg.getConstantText(object));
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String getConstantText(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof UnicodeString) {
            return "\"" + ((UnicodeString)object).getString() + "\"";
        }
        if (object instanceof Double) {
            return ((Double)object).toString();
        }
        if (object instanceof Boolean) {
            ((Boolean)object).toString();
        }
        if (object instanceof ErrorConstant) {
            return ((ErrorConstant)object).getText();
        }
        throw new IllegalArgumentException("Unexpected constant class (" + object.getClass().getName() + ")");
    }

    public byte getDefaultOperandClass() {
        return 64;
    }

    public Object clone() {
        ArrayPtg arrayPtg = (ArrayPtg)super.clone();
        arrayPtg.field_1_reserved = (byte[])this.field_1_reserved.clone();
        arrayPtg.token_3_arrayValues = (Object[])this.token_3_arrayValues.clone();
        return arrayPtg;
    }
}

