/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaI;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.AreaReference;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public abstract class AreaPtgBase
extends OperandPtg
implements AreaI {
    public static final short sid = 37;
    private static final int SIZE = 9;
    private int field_1_first_row;
    private int field_2_last_row;
    private int field_3_first_column;
    private int field_4_last_column;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField columnMask = BitFieldFactory.getInstance(16383);

    protected final RuntimeException notImplemented() {
        return new RuntimeException("Coding Error: This method should never be called. This ptg should be converted");
    }

    protected AreaPtgBase(String string) {
        AreaReference areaReference = new AreaReference(string);
        CellReference cellReference = areaReference.getFirstCell();
        CellReference cellReference2 = areaReference.getLastCell();
        this.setFirstRow(cellReference.getRow());
        this.setFirstColumn(cellReference.getCol());
        this.setLastRow(cellReference2.getRow());
        this.setLastColumn(cellReference2.getCol());
        this.setFirstColRelative(!cellReference.isColAbsolute());
        this.setLastColRelative(!cellReference2.isColAbsolute());
        this.setFirstRowRelative(!cellReference.isRowAbsolute());
        this.setLastRowRelative(!cellReference2.isRowAbsolute());
    }

    protected AreaPtgBase(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        AreaPtgBase.checkColumnBounds(n3);
        AreaPtgBase.checkColumnBounds(n4);
        AreaPtgBase.checkRowBounds(n);
        AreaPtgBase.checkRowBounds(n2);
        this.setFirstRow(n);
        this.setLastRow(n2);
        this.setFirstColumn(n3);
        this.setLastColumn(n4);
        this.setFirstRowRelative(bl);
        this.setLastRowRelative(bl2);
        this.setFirstColRelative(bl3);
        this.setLastColRelative(bl4);
    }

    private static void checkColumnBounds(int n) {
        if ((n & 0xFF) != n) {
            throw new IllegalArgumentException("colIx (" + n + ") is out of range");
        }
    }

    private static void checkRowBounds(int n) {
        if ((n & 0xFFFF) != n) {
            throw new IllegalArgumentException("rowIx (" + n + ") is out of range");
        }
    }

    protected AreaPtgBase(RecordInputStream recordInputStream) {
        this.field_1_first_row = recordInputStream.readUShort();
        this.field_2_last_row = recordInputStream.readUShort();
        this.field_3_first_column = recordInputStream.readUShort();
        this.field_4_last_column = recordInputStream.readUShort();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append(AreaReference.formatAsString(this));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected abstract byte getSid();

    public final void writeBytes(byte[] byArray, int n) {
        byArray[n] = (byte)(this.getSid() + this.getPtgClass());
        LittleEndian.putShort(byArray, n + 1, (short)this.field_1_first_row);
        LittleEndian.putShort(byArray, n + 3, (short)this.field_2_last_row);
        LittleEndian.putShort(byArray, n + 5, (short)this.field_3_first_column);
        LittleEndian.putShort(byArray, n + 7, (short)this.field_4_last_column);
    }

    public final int getSize() {
        return 9;
    }

    public final int getFirstRow() {
        return this.field_1_first_row;
    }

    public final void setFirstRow(int n) {
        AreaPtgBase.checkRowBounds(n);
        this.field_1_first_row = n;
    }

    public final int getLastRow() {
        return this.field_2_last_row;
    }

    public final void setLastRow(int n) {
        AreaPtgBase.checkRowBounds(n);
        this.field_2_last_row = n;
    }

    public final int getFirstColumn() {
        return columnMask.getValue(this.field_3_first_column);
    }

    public final short getFirstColumnRaw() {
        return (short)this.field_3_first_column;
    }

    public final boolean isFirstRowRelative() {
        return rowRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstRowRelative(boolean bl) {
        this.field_3_first_column = rowRelative.setBoolean(this.field_3_first_column, bl);
    }

    public final boolean isFirstColRelative() {
        return colRelative.isSet(this.field_3_first_column);
    }

    public final void setFirstColRelative(boolean bl) {
        this.field_3_first_column = colRelative.setBoolean(this.field_3_first_column, bl);
    }

    public final void setFirstColumn(int n) {
        AreaPtgBase.checkColumnBounds(n);
        this.field_3_first_column = columnMask.setValue(this.field_3_first_column, n);
    }

    public final void setFirstColumnRaw(int n) {
        this.field_3_first_column = n;
    }

    public final int getLastColumn() {
        return columnMask.getValue(this.field_4_last_column);
    }

    public final short getLastColumnRaw() {
        return (short)this.field_4_last_column;
    }

    public final boolean isLastRowRelative() {
        return rowRelative.isSet(this.field_4_last_column);
    }

    public final void setLastRowRelative(boolean bl) {
        this.field_4_last_column = rowRelative.setBoolean(this.field_4_last_column, bl);
    }

    public final boolean isLastColRelative() {
        return colRelative.isSet(this.field_4_last_column);
    }

    public final void setLastColRelative(boolean bl) {
        this.field_4_last_column = colRelative.setBoolean(this.field_4_last_column, bl);
    }

    public final void setLastColumn(int n) {
        AreaPtgBase.checkColumnBounds(n);
        this.field_4_last_column = columnMask.setValue(this.field_4_last_column, n);
    }

    public final void setLastColumnRaw(short s) {
        this.field_4_last_column = s;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return AreaReference.formatAsString(this);
    }

    public byte getDefaultOperandClass() {
        return 0;
    }
}

