/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaI;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ref3DPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.SheetNameFormatter;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.hssf.util.AreaReference;
import com.fr.third.org.apache.poi.hssf.util.CellReference;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class Area3DPtg
extends OperandPtg
implements AreaI {
    public static final byte sid = 59;
    private static final int SIZE = 11;
    private short field_1_index_extern_sheet;
    private int field_2_first_row;
    private int field_3_last_row;
    private int field_4_first_column;
    private int field_5_last_column;
    private BitField rowRelative = BitFieldFactory.getInstance(32768);
    private BitField colRelative = BitFieldFactory.getInstance(16384);

    public Area3DPtg() {
    }

    public Area3DPtg(String string, short s) {
        this.setArea(string);
        this.setExternSheetIndex(s);
    }

    public Area3DPtg(RecordInputStream recordInputStream) {
        this.field_1_index_extern_sheet = recordInputStream.readShort();
        this.field_2_first_row = recordInputStream.readUShort();
        this.field_3_last_row = recordInputStream.readUShort();
        this.field_4_first_column = recordInputStream.readUShort();
        this.field_5_last_column = recordInputStream.readUShort();
    }

    public Area3DPtg(short s, short s2, short s3, short s4, boolean bl, boolean bl2, boolean bl3, boolean bl4, short s5) {
        this.setFirstRow(s);
        this.setLastRow(s2);
        this.setFirstColumn(s3);
        this.setLastColumn(s4);
        this.setFirstRowRelative(bl);
        this.setLastRowRelative(bl2);
        this.setFirstColRelative(bl3);
        this.setLastColRelative(bl4);
        this.setExternSheetIndex(s5);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append("sheetIx=").append(this.getExternSheetIndex());
        stringBuffer.append(" ! ");
        stringBuffer.append(AreaReference.formatAsString(this));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void writeBytes(byte[] byArray, int n) {
        byArray[0 + n] = (byte)(59 + this.getPtgClass());
        LittleEndian.putShort(byArray, 1 + n, this.getExternSheetIndex());
        LittleEndian.putShort(byArray, 3 + n, (short)this.getFirstRow());
        LittleEndian.putShort(byArray, 5 + n, (short)this.getLastRow());
        LittleEndian.putShort(byArray, 7 + n, (short)this.getFirstColumnRaw());
        LittleEndian.putShort(byArray, 9 + n, (short)this.getLastColumnRaw());
    }

    public int getSize() {
        return 11;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short s) {
        this.field_1_index_extern_sheet = s;
    }

    public int getFirstRow() {
        return this.field_2_first_row;
    }

    public void setFirstRow(int n) {
        this.field_2_first_row = n;
    }

    public int getLastRow() {
        return this.field_3_last_row;
    }

    public void setLastRow(int n) {
        this.field_3_last_row = n;
    }

    public int getFirstColumn() {
        return this.field_4_first_column & 0xFF;
    }

    public int getFirstColumnRaw() {
        return this.field_4_first_column;
    }

    public boolean isFirstRowRelative() {
        return this.rowRelative.isSet(this.field_4_first_column);
    }

    public boolean isFirstColRelative() {
        return this.colRelative.isSet(this.field_4_first_column);
    }

    public void setFirstColumn(short s) {
        this.field_4_first_column &= 0xFF00;
        this.field_4_first_column |= s & 0xFF;
    }

    public void setFirstColumnRaw(short s) {
        this.field_4_first_column = s;
    }

    public int getLastColumn() {
        return this.field_5_last_column & 0xFF;
    }

    public int getLastColumnRaw() {
        return this.field_5_last_column;
    }

    public boolean isLastRowRelative() {
        return this.rowRelative.isSet(this.field_5_last_column);
    }

    public boolean isLastColRelative() {
        return this.colRelative.isSet(this.field_5_last_column);
    }

    public void setLastColumn(short s) {
        this.field_5_last_column &= 0xFF00;
        this.field_5_last_column |= s & 0xFF;
    }

    public void setLastColumnRaw(short s) {
        this.field_5_last_column = s;
    }

    public void setFirstRowRelative(boolean bl) {
        this.field_4_first_column = this.rowRelative.setBoolean(this.field_4_first_column, bl);
    }

    public void setFirstColRelative(boolean bl) {
        this.field_4_first_column = this.colRelative.setBoolean(this.field_4_first_column, bl);
    }

    public void setLastRowRelative(boolean bl) {
        this.field_5_last_column = this.rowRelative.setBoolean(this.field_5_last_column, bl);
    }

    public void setLastColRelative(boolean bl) {
        this.field_5_last_column = this.colRelative.setBoolean(this.field_5_last_column, bl);
    }

    public void setArea(String string) {
        AreaReference areaReference = new AreaReference(string);
        CellReference cellReference = areaReference.getFirstCell();
        CellReference cellReference2 = areaReference.getLastCell();
        this.setFirstRow((short)cellReference.getRow());
        this.setFirstColumn(cellReference.getCol());
        this.setLastRow((short)cellReference2.getRow());
        this.setLastColumn(cellReference2.getCol());
        this.setFirstColRelative(!cellReference.isColAbsolute());
        this.setLastColRelative(!cellReference2.isColAbsolute());
        this.setFirstRowRelative(!cellReference.isRowAbsolute());
        this.setLastRowRelative(!cellReference2.isRowAbsolute());
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Ref3DPtg.getSheetName(hSSFWorkbook, this.field_1_index_extern_sheet);
        if (string != null) {
            if (string.length() == 0) {
                string = "#REF";
                stringBuffer.append(string);
            } else {
                SheetNameFormatter.appendFormat(stringBuffer, string);
            }
            stringBuffer.append('!');
        }
        stringBuffer.append(AreaReference.formatAsString(this));
        return stringBuffer.toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Area3DPtg)) {
            return false;
        }
        Area3DPtg area3DPtg = (Area3DPtg)object;
        if (this.field_1_index_extern_sheet != area3DPtg.field_1_index_extern_sheet) {
            return false;
        }
        if (this.field_2_first_row != area3DPtg.field_2_first_row) {
            return false;
        }
        if (this.field_3_last_row != area3DPtg.field_3_last_row) {
            return false;
        }
        if (this.field_4_first_column != area3DPtg.field_4_first_column) {
            return false;
        }
        return this.field_5_last_column == area3DPtg.field_5_last_column;
    }
}

