/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula;

import com.fr.third.org.apache.poi.hssf.record.formula.OperationPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import com.fr.third.org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;

public abstract class AbstractFunctionPtg
extends OperationPtg {
    public static final String FUNCTION_NAME_IF = "IF";
    private static final short FUNCTION_INDEX_EXTERNAL = 255;
    protected byte returnClass;
    protected byte[] paramClass;
    protected byte field_1_num_args;
    protected short field_2_fnc_index;

    public final boolean isBaseToken() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.field_2_fnc_index).append(" ").append(this.field_1_num_args);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public short getFunctionIndex() {
        return this.field_2_fnc_index;
    }

    public String getName() {
        return this.lookupName(this.field_2_fnc_index);
    }

    public boolean isExternalFunction() {
        return this.field_2_fnc_index == 255;
    }

    public String toFormulaString(HSSFWorkbook hSSFWorkbook) {
        return this.getName();
    }

    public String toFormulaString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isExternalFunction()) {
            stringBuffer.append(stringArray[0]);
            AbstractFunctionPtg.appendArgs(stringBuffer, 1, stringArray);
        } else {
            stringBuffer.append(this.getName());
            AbstractFunctionPtg.appendArgs(stringBuffer, 0, stringArray);
        }
        return stringBuffer.toString();
    }

    private static void appendArgs(StringBuffer stringBuffer, int n, String[] stringArray) {
        stringBuffer.append('(');
        for (int i = n; i < stringArray.length; ++i) {
            if (i > n) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")");
    }

    public abstract void writeBytes(byte[] var1, int var2);

    public abstract int getSize();

    public static final boolean isInternalFunctionName(String string) {
        short s = FunctionMetadataRegistry.lookupIndexByName(string.toUpperCase());
        return s >= 0;
    }

    protected String lookupName(short s) {
        if (s == 255) {
            return "#external#";
        }
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(s);
        if (functionMetadata == null) {
            throw new RuntimeException("bad function index (" + s + ")");
        }
        return functionMetadata.getName();
    }

    protected static short lookupIndex(String string) {
        short s = FunctionMetadataRegistry.lookupIndexByName(string.toUpperCase());
        if (s < 0) {
            return 255;
        }
        return s;
    }

    public byte getDefaultOperandClass() {
        return this.returnClass;
    }

    public byte getParameterClass(int n) {
        if (n >= this.paramClass.length) {
            return this.paramClass[this.paramClass.length - 1];
        }
        return this.paramClass[n];
    }
}

