/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.constant;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.hssf.record.constant.ErrorConstant;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class ConstantValueParser {
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_STRING = 2;
    private static final int TYPE_BOOLEAN = 4;
    private static final int TYPE_ERROR_CODE = 16;
    private static final int TRUE_ENCODING = 1;
    private static final int FALSE_ENCODING = 0;
    private static final Object EMPTY_REPRESENTATION = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$constant$ErrorConstant;

    private ConstantValueParser() {
    }

    public static Object[] parse(RecordInputStream recordInputStream, int n) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ConstantValueParser.readAConstantValue(recordInputStream);
        }
        return objectArray;
    }

    private static Object readAConstantValue(RecordInputStream recordInputStream) {
        byte by = recordInputStream.readByte();
        switch (by) {
            case 0: {
                recordInputStream.readLong();
                return EMPTY_REPRESENTATION;
            }
            case 1: {
                return new Double(recordInputStream.readDouble());
            }
            case 2: {
                return recordInputStream.readUnicodeString();
            }
            case 4: {
                return ConstantValueParser.readBoolean(recordInputStream);
            }
            case 16: {
                int n = recordInputStream.readUShort();
                recordInputStream.readUShort();
                recordInputStream.readInt();
                return ErrorConstant.valueOf(n);
            }
        }
        throw new RuntimeException("Unknown grbit value (" + by + ")");
    }

    private static Object readBoolean(RecordInputStream recordInputStream) {
        byte by = (byte)recordInputStream.readLong();
        switch (by) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new RuntimeException("unexpected boolean encoding (" + by + ")");
    }

    public static int getEncodedSize(Object[] objectArray) {
        int n = objectArray.length * 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n += ConstantValueParser.getEncodedSize(objectArray[i]);
        }
        return n;
    }

    private static int getEncodedSize(Object object) {
        if (object == EMPTY_REPRESENTATION) {
            return 8;
        }
        Class<?> clazz = object.getClass();
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConstantValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ConstantValueParser.class$("java.lang.Double")) : class$java$lang$Double) || clazz == (class$com$fr$third$org$apache$poi$hssf$record$constant$ErrorConstant == null ? (class$com$fr$third$org$apache$poi$hssf$record$constant$ErrorConstant = ConstantValueParser.class$("com.fr.third.org.apache.poi.hssf.record.constant.ErrorConstant")) : class$com$fr$third$org$apache$poi$hssf$record$constant$ErrorConstant)) {
            return 8;
        }
        UnicodeString unicodeString = (UnicodeString)object;
        UnicodeString.UnicodeRecordStats unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
        unicodeString.getRecordSize(unicodeRecordStats);
        return unicodeRecordStats.recordSize;
    }

    public static void encode(byte[] byArray, int n, Object[] objectArray) {
        int n2 = n;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 += ConstantValueParser.encodeSingleValue(byArray, n2, objectArray[i]);
        }
    }

    private static int encodeSingleValue(byte[] byArray, int n, Object object) {
        if (object == EMPTY_REPRESENTATION) {
            LittleEndian.putByte(byArray, n, 0);
            LittleEndian.putLong(byArray, n + 1, 0L);
            return 9;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            LittleEndian.putByte(byArray, n, 4);
            long l = bl != false ? 1L : 0L;
            LittleEndian.putLong(byArray, n + 1, l);
            return 9;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            LittleEndian.putByte(byArray, n, 1);
            LittleEndian.putDouble(byArray, n + 1, d);
            return 9;
        }
        if (object instanceof UnicodeString) {
            UnicodeString unicodeString = (UnicodeString)object;
            LittleEndian.putByte(byArray, n, 2);
            UnicodeString.UnicodeRecordStats unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
            unicodeString.serialize(unicodeRecordStats, n + 1, byArray);
            return 1 + unicodeRecordStats.recordSize;
        }
        if (object instanceof ErrorConstant) {
            ErrorConstant errorConstant = (ErrorConstant)object;
            LittleEndian.putByte(byArray, n, 16);
            LittleEndian.putUShort(byArray, n + 1, errorConstant.getErrorCode());
            LittleEndian.putUShort(byArray, n + 3, 0);
            LittleEndian.putInt(byArray, n + 5, 0);
            return 9;
        }
        throw new IllegalStateException("Unexpected value type (" + object.getClass().getName() + "'");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

