/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.cf;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class PatternFormatting
implements Cloneable {
    public static final short NO_FILL = 0;
    public static final short SOLID_FOREGROUND = 1;
    public static final short FINE_DOTS = 2;
    public static final short ALT_BARS = 3;
    public static final short SPARSE_DOTS = 4;
    public static final short THICK_HORZ_BANDS = 5;
    public static final short THICK_VERT_BANDS = 6;
    public static final short THICK_BACKWARD_DIAG = 7;
    public static final short THICK_FORWARD_DIAG = 8;
    public static final short BIG_SPOTS = 9;
    public static final short BRICKS = 10;
    public static final short THIN_HORZ_BANDS = 11;
    public static final short THIN_VERT_BANDS = 12;
    public static final short THIN_BACKWARD_DIAG = 13;
    public static final short THIN_FORWARD_DIAG = 14;
    public static final short SQUARES = 15;
    public static final short DIAMONDS = 16;
    public static final short LESS_DOTS = 17;
    public static final short LEAST_DOTS = 18;
    private short field_15_pattern_style;
    private static final BitField fillPatternStyle = BitFieldFactory.getInstance(64512);
    private short field_16_pattern_color_indexes;
    private static final BitField patternColorIndex = BitFieldFactory.getInstance(127);
    private static final BitField patternBackgroundColorIndex = BitFieldFactory.getInstance(16256);

    public PatternFormatting() {
        this.field_15_pattern_style = 0;
        this.field_16_pattern_color_indexes = 0;
    }

    public PatternFormatting(RecordInputStream recordInputStream) {
        this.field_15_pattern_style = recordInputStream.readShort();
        this.field_16_pattern_color_indexes = recordInputStream.readShort();
    }

    public void setFillPattern(short s) {
        this.field_15_pattern_style = fillPatternStyle.setShortValue(this.field_15_pattern_style, s);
    }

    public short getFillPattern() {
        return fillPatternStyle.getShortValue(this.field_15_pattern_style);
    }

    public void setFillBackgroundColor(short s) {
        this.field_16_pattern_color_indexes = patternBackgroundColorIndex.setShortValue(this.field_16_pattern_color_indexes, s);
    }

    public short getFillBackgroundColor() {
        return patternBackgroundColorIndex.getShortValue(this.field_16_pattern_color_indexes);
    }

    public void setFillForegroundColor(short s) {
        this.field_16_pattern_color_indexes = patternColorIndex.setShortValue(this.field_16_pattern_color_indexes, s);
    }

    public short getFillForegroundColor() {
        return patternColorIndex.getShortValue(this.field_16_pattern_color_indexes);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [Pattern Formatting]\n");
        stringBuffer.append("          .fillpattern= ").append(Integer.toHexString(this.getFillPattern())).append("\n");
        stringBuffer.append("          .fgcoloridx= ").append(Integer.toHexString(this.getFillForegroundColor())).append("\n");
        stringBuffer.append("          .bgcoloridx= ").append(Integer.toHexString(this.getFillBackgroundColor())).append("\n");
        stringBuffer.append("    [/Pattern Formatting]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        PatternFormatting patternFormatting = new PatternFormatting();
        patternFormatting.field_15_pattern_style = this.field_15_pattern_style;
        patternFormatting.field_16_pattern_color_indexes = this.field_16_pattern_color_indexes;
        return patternFormatting;
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, n, this.field_15_pattern_style);
        LittleEndian.putShort(byArray, n += 2, this.field_16_pattern_color_indexes);
        n += 2;
        return 4;
    }
}

