/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.cf;

import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class FontFormatting {
    private byte[] _rawData;
    private static final int OFFSET_FONT_NAME = 0;
    private static final int OFFSET_FONT_HEIGHT = 64;
    private static final int OFFSET_FONT_OPTIONS = 68;
    private static final int OFFSET_FONT_WEIGHT = 72;
    private static final int OFFSET_ESCAPEMENT_TYPE = 74;
    private static final int OFFSET_UNDERLINE_TYPE = 76;
    private static final int OFFSET_FONT_COLOR_INDEX = 80;
    private static final int OFFSET_OPTION_FLAGS = 88;
    private static final int OFFSET_ESCAPEMENT_TYPE_MODIFIED = 92;
    private static final int OFFSET_UNDERLINE_TYPE_MODIFIED = 96;
    private static final int OFFSET_FONT_WEIGHT_MODIFIED = 100;
    private static final int OFFSET_NOT_USED1 = 104;
    private static final int OFFSET_NOT_USED2 = 108;
    private static final int OFFSET_NOT_USED3 = 112;
    private static final int OFFSET_FONT_FORMATING_END = 116;
    private static final int RAW_DATA_SIZE = 118;
    public static final int FONT_CELL_HEIGHT_PRESERVED = -1;
    private static final BitField posture = BitFieldFactory.getInstance(2);
    private static final BitField outline = BitFieldFactory.getInstance(8);
    private static final BitField shadow = BitFieldFactory.getInstance(16);
    private static final BitField cancellation = BitFieldFactory.getInstance(128);
    private static final BitField styleModified = BitFieldFactory.getInstance(2);
    private static final BitField outlineModified = BitFieldFactory.getInstance(8);
    private static final BitField shadowModified = BitFieldFactory.getInstance(16);
    private static final BitField cancellationModified = BitFieldFactory.getInstance(128);
    public static final short SS_NONE = 0;
    public static final short SS_SUPER = 1;
    public static final short SS_SUB = 2;
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private static final short FONT_WEIGHT_NORMAL = 400;
    private static final short FONT_WEIGHT_BOLD = 700;

    private FontFormatting(byte[] byArray) {
        this._rawData = byArray;
    }

    public FontFormatting() {
        this(new byte[118]);
        this.setFontHeight(-1);
        this.setItalic(false);
        this.setFontWieghtModified(false);
        this.setOutline(false);
        this.setShadow(false);
        this.setStrikeout(false);
        this.setEscapementType((short)0);
        this.setUnderlineType((short)0);
        this.setFontColorIndex((short)-1);
        this.setFontStyleModified(false);
        this.setFontOutlineModified(false);
        this.setFontShadowModified(false);
        this.setFontCancellationModified(false);
        this.setEscapementTypeModified(false);
        this.setUnderlineTypeModified(false);
        this.setShort(0, 0);
        this.setInt(104, 1);
        this.setInt(108, 0);
        this.setInt(112, Integer.MAX_VALUE);
        this.setShort(116, 1);
    }

    public FontFormatting(RecordInputStream recordInputStream) {
        this(new byte[118]);
        for (int i = 0; i < this._rawData.length; ++i) {
            this._rawData[i] = recordInputStream.readByte();
        }
    }

    private short getShort(int n) {
        return LittleEndian.getShort(this._rawData, n);
    }

    private void setShort(int n, int n2) {
        LittleEndian.putShort(this._rawData, n, (short)n2);
    }

    private int getInt(int n) {
        return LittleEndian.getInt(this._rawData, n);
    }

    private void setInt(int n, int n2) {
        LittleEndian.putInt(this._rawData, n, n2);
    }

    public byte[] getRawRecord() {
        return this._rawData;
    }

    public void setFontHeight(int n) {
        this.setInt(64, n);
    }

    public int getFontHeight() {
        return this.getInt(64);
    }

    private void setFontOption(boolean bl, BitField bitField) {
        int n = this.getInt(68);
        n = bitField.setBoolean(n, bl);
        this.setInt(68, n);
    }

    private boolean getFontOption(BitField bitField) {
        int n = this.getInt(68);
        return bitField.isSet(n);
    }

    public void setItalic(boolean bl) {
        this.setFontOption(bl, posture);
    }

    public boolean isItalic() {
        return this.getFontOption(posture);
    }

    public void setOutline(boolean bl) {
        this.setFontOption(bl, outline);
    }

    public boolean isOutlineOn() {
        return this.getFontOption(outline);
    }

    public void setShadow(boolean bl) {
        this.setFontOption(bl, shadow);
    }

    public boolean isShadowOn() {
        return this.getFontOption(shadow);
    }

    public void setStrikeout(boolean bl) {
        this.setFontOption(bl, cancellation);
    }

    public boolean isStruckout() {
        return this.getFontOption(cancellation);
    }

    private void setFontWeight(short n) {
        int n2 = n;
        if (n2 < 100) {
            n2 = 100;
        }
        if (n2 > 1000) {
            n2 = 1000;
        }
        this.setShort(72, n2);
    }

    public void setBold(boolean bl) {
        this.setFontWeight(bl ? (short)700 : 400);
    }

    public short getFontWeight() {
        return this.getShort(72);
    }

    public boolean isBold() {
        return this.getFontWeight() == 700;
    }

    public short getEscapementType() {
        return this.getShort(74);
    }

    public void setEscapementType(short s) {
        this.setShort(74, s);
    }

    public short getUnderlineType() {
        return this.getShort(76);
    }

    public void setUnderlineType(short s) {
        this.setShort(76, s);
    }

    public short getFontColorIndex() {
        return (short)this.getInt(80);
    }

    public void setFontColorIndex(short s) {
        this.setInt(80, s);
    }

    private boolean getOptionFlag(BitField bitField) {
        int n = this.getInt(88);
        int n2 = bitField.getValue(n);
        return n2 == 0;
    }

    private void setOptionFlag(boolean bl, BitField bitField) {
        int n = bl ? 0 : 1;
        int n2 = this.getInt(88);
        n2 = bitField.setValue(n2, n);
        this.setInt(88, n2);
    }

    public boolean isFontStyleModified() {
        return this.getOptionFlag(styleModified);
    }

    public void setFontStyleModified(boolean bl) {
        this.setOptionFlag(bl, styleModified);
    }

    public boolean isFontOutlineModified() {
        return this.getOptionFlag(outlineModified);
    }

    public void setFontOutlineModified(boolean bl) {
        this.setOptionFlag(bl, outlineModified);
    }

    public boolean isFontShadowModified() {
        return this.getOptionFlag(shadowModified);
    }

    public void setFontShadowModified(boolean bl) {
        this.setOptionFlag(bl, shadowModified);
    }

    public void setFontCancellationModified(boolean bl) {
        this.setOptionFlag(bl, cancellationModified);
    }

    public boolean isFontCancellationModified() {
        return this.getOptionFlag(cancellationModified);
    }

    public void setEscapementTypeModified(boolean bl) {
        int n = bl ? 0 : 1;
        this.setInt(92, n);
    }

    public boolean isEscapementTypeModified() {
        int n = this.getInt(92);
        return n == 0;
    }

    public void setUnderlineTypeModified(boolean bl) {
        int n = bl ? 0 : 1;
        this.setInt(96, n);
    }

    public boolean isUnderlineTypeModified() {
        int n = this.getInt(96);
        return n == 0;
    }

    public void setFontWieghtModified(boolean bl) {
        int n = bl ? 0 : 1;
        this.setInt(100, n);
    }

    public boolean isFontWeightModified() {
        int n = this.getInt(100);
        return n == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t[Font Formatting]\n");
        stringBuffer.append("\t.font height = ").append(this.getFontHeight()).append(" twips\n");
        if (this.isFontStyleModified()) {
            stringBuffer.append("\t.font posture = ").append(this.isItalic() ? "Italic" : "Normal").append("\n");
        } else {
            stringBuffer.append("\t.font posture = ]not modified]").append("\n");
        }
        if (this.isFontOutlineModified()) {
            stringBuffer.append("\t.font outline = ").append(this.isOutlineOn()).append("\n");
        } else {
            stringBuffer.append("\t.font outline is not modified\n");
        }
        if (this.isFontShadowModified()) {
            stringBuffer.append("\t.font shadow = ").append(this.isShadowOn()).append("\n");
        } else {
            stringBuffer.append("\t.font shadow is not modified\n");
        }
        if (this.isFontCancellationModified()) {
            stringBuffer.append("\t.font strikeout = ").append(this.isStruckout()).append("\n");
        } else {
            stringBuffer.append("\t.font strikeout is not modified\n");
        }
        if (this.isFontStyleModified()) {
            stringBuffer.append("\t.font weight = ").append(this.getFontWeight()).append(this.getFontWeight() == 400 ? "(Normal)" : (this.getFontWeight() == 700 ? "(Bold)" : "0x" + Integer.toHexString(this.getFontWeight()))).append("\n");
        } else {
            stringBuffer.append("\t.font weight = ]not modified]").append("\n");
        }
        if (this.isEscapementTypeModified()) {
            stringBuffer.append("\t.escapement type = ").append(this.getEscapementType()).append("\n");
        } else {
            stringBuffer.append("\t.escapement type is not modified\n");
        }
        if (this.isUnderlineTypeModified()) {
            stringBuffer.append("\t.underline type = ").append(this.getUnderlineType()).append("\n");
        } else {
            stringBuffer.append("\t.underline type is not modified\n");
        }
        stringBuffer.append("\t.color index = ").append("0x" + Integer.toHexString(this.getFontColorIndex()).toUpperCase()).append("\n");
        stringBuffer.append("\t[/Font Formatting]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        byte[] byArray = (byte[])this._rawData.clone();
        return new FontFormatting(byArray);
    }
}

