/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.cf;

import com.fr.third.org.apache.poi.hssf.util.Region;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CellRange {
    private static final int LAST_ROW_INDEX = 65535;
    private static final int LAST_COLUMN_INDEX = 255;
    private static final Region[] EMPTY_REGION_ARRAY = new Region[0];
    private int _firstRow;
    private int _lastRow;
    private int _firstColumn;
    private int _lastColumn;
    public static final int NO_INTERSECTION = 1;
    public static final int OVERLAP = 2;
    public static final int INSIDE = 3;
    public static final int ENCLOSES = 4;

    public CellRange(int n, int n2, int n3, int n4) {
        if (!CellRange.isValid(n, n2, n3, n4)) {
            throw new IllegalArgumentException("invalid cell range (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        this._firstRow = n;
        this._lastRow = CellRange.convertM1ToMax(n2, 65535);
        this._firstColumn = n3;
        this._lastColumn = CellRange.convertM1ToMax(n4, 255);
    }

    private static int convertM1ToMax(int n, int n2) {
        if (n < 0) {
            return n2;
        }
        return n;
    }

    public boolean isFullColumnRange() {
        return this._firstRow == 0 && this._lastRow == 65535;
    }

    public boolean isFullRowRange() {
        return this._firstColumn == 0 && this._lastColumn == 255;
    }

    private static CellRange createFromRegion(Region region) {
        return new CellRange(region.getRowFrom(), region.getRowTo(), region.getColumnFrom(), region.getColumnTo());
    }

    private static boolean isValid(int n, int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 65535) {
            return false;
        }
        if (n < 0 || n > 65535) {
            return false;
        }
        if (n4 < 0 || n4 > 255) {
            return false;
        }
        return n3 >= 0 && n3 <= 255;
    }

    public int getFirstRow() {
        return this._firstRow;
    }

    public int getLastRow() {
        return this._lastRow;
    }

    public int getFirstColumn() {
        return this._firstColumn;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public int intersect(CellRange cellRange) {
        int n = cellRange.getFirstRow();
        int n2 = cellRange.getLastRow();
        int n3 = cellRange.getFirstColumn();
        int n4 = cellRange.getLastColumn();
        if (CellRange.gt(this.getFirstRow(), n2) || CellRange.lt(this.getLastRow(), n) || CellRange.gt(this.getFirstColumn(), n4) || CellRange.lt(this.getLastColumn(), n3)) {
            return 1;
        }
        if (this.contains(cellRange)) {
            return 3;
        }
        if (cellRange.contains(this)) {
            return 4;
        }
        return 2;
    }

    public static CellRange[] mergeCellRanges(CellRange[] cellRangeArray) {
        if (cellRangeArray.length < 1) {
            return cellRangeArray;
        }
        List list = CellRange.mergeCellRanges(Arrays.asList(cellRangeArray));
        return CellRange.toArray(list);
    }

    private static List mergeCellRanges(List list) {
        while (list.size() > 1) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                CellRange cellRange = (CellRange)list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    CellRange cellRange2 = (CellRange)list.get(j);
                    CellRange[] cellRangeArray = CellRange.mergeRanges(cellRange, cellRange2);
                    if (cellRangeArray == null) continue;
                    bl = true;
                    list.set(i, cellRangeArray[0]);
                    list.remove(j--);
                    for (int k = 1; k < cellRangeArray.length; ++k) {
                        list.add(++j, cellRangeArray[k]);
                    }
                }
            }
            if (bl) continue;
            break;
        }
        return list;
    }

    private static CellRange[] mergeRanges(CellRange cellRange, CellRange cellRange2) {
        int n = cellRange.intersect(cellRange2);
        switch (n) {
            case 1: {
                if (cellRange.hasExactSharedBorder(cellRange2)) {
                    return new CellRange[]{cellRange.createEnclosingCellRange(cellRange2)};
                }
                return null;
            }
            case 2: {
                return CellRange.resolveRangeOverlap(cellRange, cellRange2);
            }
            case 3: {
                return new CellRange[]{cellRange};
            }
            case 4: {
                return new CellRange[]{cellRange2};
            }
        }
        throw new RuntimeException("unexpected intersection result (" + n + ")");
    }

    static CellRange[] resolveRangeOverlap(CellRange cellRange, CellRange cellRange2) {
        if (cellRange.isFullColumnRange()) {
            if (cellRange2.isFullRowRange()) {
                return null;
            }
            return cellRange.sliceUp(cellRange2);
        }
        if (cellRange.isFullRowRange()) {
            if (cellRange2.isFullColumnRange()) {
                return null;
            }
            return cellRange.sliceUp(cellRange2);
        }
        if (cellRange2.isFullColumnRange()) {
            return cellRange2.sliceUp(cellRange);
        }
        if (cellRange2.isFullRowRange()) {
            return cellRange2.sliceUp(cellRange);
        }
        return cellRange.sliceUp(cellRange2);
    }

    private CellRange[] sliceUp(CellRange cellRange) {
        List<CellRange> list = new ArrayList<CellRange>();
        list.add(cellRange);
        if (!this.isFullColumnRange()) {
            list = CellRange.cutHorizontally(this._firstRow, list);
            list = CellRange.cutHorizontally(this._lastRow + 1, list);
        }
        if (!this.isFullRowRange()) {
            list = CellRange.cutVertically(this._firstColumn, list);
            list = CellRange.cutVertically(this._lastColumn + 1, list);
        }
        CellRange[] cellRangeArray = CellRange.toArray(list);
        list.clear();
        list.add(this);
        for (int i = 0; i < cellRangeArray.length; ++i) {
            CellRange cellRange2 = cellRangeArray[i];
            if (this.intersect(cellRange2) == 4) continue;
            list.add(cellRange2);
        }
        return CellRange.toArray(list);
    }

    private static List cutHorizontally(int n, List list) {
        ArrayList<CellRange> arrayList = new ArrayList<CellRange>();
        CellRange[] cellRangeArray = CellRange.toArray(list);
        for (int i = 0; i < cellRangeArray.length; ++i) {
            CellRange cellRange = cellRangeArray[i];
            if (cellRange._firstRow < n && n < cellRange._lastRow) {
                arrayList.add(new CellRange(cellRange._firstRow, n, cellRange._firstColumn, cellRange._lastColumn));
                arrayList.add(new CellRange(n + 1, cellRange._lastRow, cellRange._firstColumn, cellRange._lastColumn));
                continue;
            }
            arrayList.add(cellRange);
        }
        return arrayList;
    }

    private static List cutVertically(int n, List list) {
        ArrayList<CellRange> arrayList = new ArrayList<CellRange>();
        CellRange[] cellRangeArray = CellRange.toArray(list);
        for (int i = 0; i < cellRangeArray.length; ++i) {
            CellRange cellRange = cellRangeArray[i];
            if (cellRange._firstColumn < n && n < cellRange._lastColumn) {
                arrayList.add(new CellRange(cellRange._firstRow, cellRange._lastRow, cellRange._firstColumn, n));
                arrayList.add(new CellRange(cellRange._firstRow, cellRange._lastRow, n + 1, cellRange._lastColumn));
                continue;
            }
            arrayList.add(cellRange);
        }
        return arrayList;
    }

    private static CellRange[] toArray(List list) {
        CellRange[] cellRangeArray = new CellRange[list.size()];
        list.toArray(cellRangeArray);
        return cellRangeArray;
    }

    public static CellRange[] convertRegionsToCellRanges(Region[] regionArray) {
        CellRange[] cellRangeArray = new CellRange[regionArray.length];
        for (int i = 0; i < regionArray.length; ++i) {
            cellRangeArray[i] = CellRange.createFromRegion(regionArray[i]);
        }
        return cellRangeArray;
    }

    public static Region[] convertCellRangesToRegions(CellRange[] cellRangeArray) {
        int n = cellRangeArray.length;
        if (n < 1) {
            return EMPTY_REGION_ARRAY;
        }
        Region[] regionArray = new Region[n];
        for (int i = 0; i != n; ++i) {
            regionArray[i] = cellRangeArray[i].convertToRegion();
        }
        return regionArray;
    }

    private Region convertToRegion() {
        return new Region(this._firstRow, (short)this._firstColumn, this._lastRow, (short)this._lastColumn);
    }

    public boolean contains(CellRange cellRange) {
        int n = cellRange.getFirstRow();
        int n2 = cellRange.getLastRow();
        int n3 = cellRange.getFirstColumn();
        int n4 = cellRange.getLastColumn();
        return CellRange.le(this.getFirstRow(), n) && CellRange.ge(this.getLastRow(), n2) && CellRange.le(this.getFirstColumn(), n3) && CellRange.ge(this.getLastColumn(), n4);
    }

    public boolean contains(int n, short s) {
        return CellRange.le(this.getFirstRow(), n) && CellRange.ge(this.getLastRow(), n) && CellRange.le(this.getFirstColumn(), s) && CellRange.ge(this.getLastColumn(), s);
    }

    public boolean hasExactSharedBorder(CellRange cellRange) {
        int n = cellRange._firstRow;
        int n2 = cellRange._lastRow;
        int n3 = cellRange._firstColumn;
        int n4 = cellRange._lastColumn;
        if (this._firstRow > 0 && this._firstRow - 1 == n2 || n > 0 && n - 1 == this._lastRow) {
            return this._firstColumn == n3 && this._lastColumn == n4;
        }
        if (this._firstColumn > 0 && this._firstColumn - 1 == n4 || n3 > 0 && this._lastColumn == n3 - 1) {
            return this._firstRow == n && this._lastRow == n2;
        }
        return false;
    }

    public CellRange createEnclosingCellRange(CellRange cellRange) {
        if (cellRange == null) {
            return this.cloneCellRange();
        }
        CellRange cellRange2 = new CellRange(CellRange.lt(cellRange.getFirstRow(), this.getFirstRow()) ? cellRange.getFirstRow() : this.getFirstRow(), CellRange.gt(cellRange.getLastRow(), this.getLastRow()) ? cellRange.getLastRow() : this.getLastRow(), CellRange.lt(cellRange.getFirstColumn(), this.getFirstColumn()) ? cellRange.getFirstColumn() : this.getFirstColumn(), CellRange.gt(cellRange.getLastColumn(), this.getLastColumn()) ? cellRange.getLastColumn() : this.getLastColumn());
        return cellRange2;
    }

    public CellRange cloneCellRange() {
        return new CellRange(this.getFirstRow(), this.getLastRow(), this.getFirstColumn(), this.getLastColumn());
    }

    private static boolean lt(int n, int n2) {
        return n == -1 ? false : (n2 == -1 ? true : n < n2);
    }

    private static boolean le(int n, int n2) {
        return n == n2 || CellRange.lt(n, n2);
    }

    private static boolean gt(int n, int n2) {
        return CellRange.lt(n2, n);
    }

    private static boolean ge(int n, int n2) {
        return !CellRange.lt(n, n2);
    }

    public String toString() {
        return "(" + this.getFirstRow() + "," + this.getLastRow() + "," + this.getFirstColumn() + "," + this.getLastColumn() + ")";
    }
}

