/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.aggregates;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.EOFRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SharedFormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ValueRecordsAggregate
extends Record {
    public static final short sid = -1001;
    int firstcell = -1;
    int lastcell = -1;
    CellValueRecordInterface[][] records = new CellValueRecordInterface[30][];

    public void insertCell(CellValueRecordInterface cellValueRecordInterface) {
        int n;
        CellValueRecordInterface[][] cellValueRecordInterfaceArray;
        short s = cellValueRecordInterface.getColumn();
        int n2 = cellValueRecordInterface.getRow();
        if (n2 >= this.records.length) {
            cellValueRecordInterfaceArray = this.records;
            n = cellValueRecordInterfaceArray.length * 2;
            if (n < n2 + 1) {
                n = n2 + 1;
            }
            this.records = new CellValueRecordInterface[n][];
            System.arraycopy(cellValueRecordInterfaceArray, 0, this.records, 0, cellValueRecordInterfaceArray.length);
        }
        if ((cellValueRecordInterfaceArray = this.records[n2]) == null) {
            n = s + 1;
            if (n < 10) {
                n = 10;
            }
            cellValueRecordInterfaceArray = new CellValueRecordInterface[n];
            this.records[n2] = cellValueRecordInterfaceArray;
        }
        if (s >= cellValueRecordInterfaceArray.length) {
            CellValueRecordInterface[][] cellValueRecordInterfaceArray2 = cellValueRecordInterfaceArray;
            int n3 = cellValueRecordInterfaceArray2.length * 2;
            if (n3 < s + 1) {
                n3 = s + 1;
            }
            cellValueRecordInterfaceArray = new CellValueRecordInterface[n3];
            System.arraycopy(cellValueRecordInterfaceArray2, 0, cellValueRecordInterfaceArray, 0, cellValueRecordInterfaceArray2.length);
            this.records[n2] = cellValueRecordInterfaceArray;
        }
        cellValueRecordInterfaceArray[s] = cellValueRecordInterface;
        if (s < this.firstcell || this.firstcell == -1) {
            this.firstcell = s;
        }
        if (s > this.lastcell || this.lastcell == -1) {
            this.lastcell = s;
        }
    }

    public void removeCell(CellValueRecordInterface cellValueRecordInterface) {
        if (cellValueRecordInterface != null) {
            short s = cellValueRecordInterface.getColumn();
            int n = cellValueRecordInterface.getRow();
            if (n >= this.records.length) {
                return;
            }
            CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[n];
            if (cellValueRecordInterfaceArray == null) {
                return;
            }
            if (s >= cellValueRecordInterfaceArray.length) {
                return;
            }
            cellValueRecordInterfaceArray[s] = null;
        }
    }

    public int getPhysicalNumberOfCells() {
        int n = 0;
        for (int i = 0; i < this.records.length; ++i) {
            CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[i];
            if (cellValueRecordInterfaceArray == null) continue;
            for (int n2 = 0; n2 < cellValueRecordInterfaceArray.length; n2 = (int)((short)(n2 + 1))) {
                if (cellValueRecordInterfaceArray[n2] == null) continue;
                ++n;
            }
        }
        return n;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public int construct(int n, List list) {
        Record record;
        int n2 = 0;
        FormulaRecordAggregate formulaRecordAggregate = null;
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (n2 = n; n2 < list.size(); ++n2) {
            record = (Record)list.get(n2);
            if (record instanceof SharedFormulaRecord) {
                arrayList.add(record);
            }
            if (record instanceof EOFRecord) break;
        }
        for (n2 = n; n2 < list.size() && ((record = (Record)list.get(n2)) instanceof StringRecord || record.isInValueSection() || record instanceof UnknownRecord); ++n2) {
            if (record instanceof SharedFormulaRecord) continue;
            if (record instanceof FormulaRecord) {
                FormulaRecord formulaRecord = (FormulaRecord)record;
                if (formulaRecord.isSharedFormula()) {
                    boolean bl = false;
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        SharedFormulaRecord sharedFormulaRecord = (SharedFormulaRecord)arrayList.get(i);
                        if (!sharedFormulaRecord.isFormulaInShared(formulaRecord)) continue;
                        sharedFormulaRecord.convertSharedFormulaRecord(formulaRecord);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        ValueRecordsAggregate.handleMissingSharedFormulaRecord(formulaRecord);
                    }
                }
                formulaRecordAggregate = new FormulaRecordAggregate((FormulaRecord)record, null);
                this.insertCell(formulaRecordAggregate);
                continue;
            }
            if (record instanceof StringRecord) {
                formulaRecordAggregate.setStringRecord((StringRecord)record);
                continue;
            }
            if (!record.isValue()) continue;
            this.insertCell((CellValueRecordInterface)((Object)record));
        }
        return n2;
    }

    private static void handleMissingSharedFormulaRecord(FormulaRecord formulaRecord) {
    }

    public int serialize(int n, byte[] byArray) {
        throw new RuntimeException("This method shouldnt be called. ValueRecordsAggregate.serializeCellRow() should be called from RowRecordsAggregate.");
    }

    public int getRowCellBlockSize(int n, int n2) {
        CellValueRecordInterface cellValueRecordInterface;
        int n3;
        MyIterator myIterator = new MyIterator(n, n2);
        int n4 = 0;
        while (myIterator.hasNext() && (n3 = (cellValueRecordInterface = (CellValueRecordInterface)myIterator.next()).getRow()) <= n2) {
            if (n3 < n || n3 > n2) continue;
            n4 += ((Record)((Object)cellValueRecordInterface)).getRecordSize();
        }
        return n4;
    }

    public boolean rowHasCells(int n) {
        if (n > this.records.length - 1) {
            return false;
        }
        CellValueRecordInterface[] cellValueRecordInterfaceArray = this.records[n];
        if (cellValueRecordInterfaceArray == null) {
            return false;
        }
        for (int i = 0; i < cellValueRecordInterfaceArray.length; ++i) {
            if (cellValueRecordInterfaceArray[i] == null) continue;
            return true;
        }
        return false;
    }

    public int serializeCellRow(int n, int n2, byte[] byArray) {
        CellValueRecordInterface cellValueRecordInterface;
        MyIterator myIterator = new MyIterator(n, n);
        int n3 = n2;
        while (myIterator.hasNext() && (cellValueRecordInterface = (CellValueRecordInterface)myIterator.next()).getRow() == n) {
            n3 += ((Record)((Object)cellValueRecordInterface)).serialize(n3, byArray);
        }
        return n3 - n2;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
    }

    protected void validateSid(short s) {
    }

    public short getSid() {
        return -1001;
    }

    public int getRecordSize() {
        int n = 0;
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            n += ((Record)iterator.next()).getRecordSize();
        }
        return n;
    }

    public Iterator getIterator() {
        return new MyIterator();
    }

    public Object clone() {
        ValueRecordsAggregate valueRecordsAggregate = new ValueRecordsAggregate();
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            CellValueRecordInterface cellValueRecordInterface = (CellValueRecordInterface)((CellValueRecordInterface)iterator.next()).clone();
            valueRecordsAggregate.insertCell(cellValueRecordInterface);
        }
        return valueRecordsAggregate;
    }

    private final class MyIterator
    implements Iterator {
        short nextColumn = (short)-1;
        int nextRow;
        int lastRow;

        public MyIterator() {
            this.nextRow = 0;
            this.lastRow = ValueRecordsAggregate.this.records.length - 1;
            this.findNext();
        }

        public MyIterator(int n, int n2) {
            this.nextRow = n;
            this.lastRow = n2;
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextRow <= this.lastRow;
        }

        public Object next() {
            CellValueRecordInterface cellValueRecordInterface = ValueRecordsAggregate.this.records[this.nextRow][this.nextColumn];
            this.findNext();
            return cellValueRecordInterface;
        }

        public void remove() {
            throw new UnsupportedOperationException("gibt's noch nicht");
        }

        private void findNext() {
            this.nextColumn = (short)(this.nextColumn + 1);
            while (this.nextRow <= this.lastRow) {
                CellValueRecordInterface[] cellValueRecordInterfaceArray;
                CellValueRecordInterface[] cellValueRecordInterfaceArray2 = cellValueRecordInterfaceArray = this.nextRow < ValueRecordsAggregate.this.records.length ? ValueRecordsAggregate.this.records[this.nextRow] : null;
                if (cellValueRecordInterfaceArray == null) {
                    this.nextColumn = 0;
                } else {
                    while (this.nextColumn < cellValueRecordInterfaceArray.length) {
                        if (cellValueRecordInterfaceArray[this.nextColumn] != null) {
                            return;
                        }
                        this.nextColumn = (short)(this.nextColumn + 1);
                    }
                    this.nextColumn = 0;
                }
                ++this.nextRow;
            }
        }
    }
}

