/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.aggregates;

import com.fr.third.org.apache.poi.hssf.record.DBCellRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.RowRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class RowRecordsAggregate
extends Record {
    private int firstrow = -1;
    private int lastrow = -1;
    private Map records = new TreeMap();
    private int size = 0;

    public void insertRow(RowRecord rowRecord) {
        this.size += rowRecord.getRecordSize();
        this.records.put(rowRecord, rowRecord);
        if (rowRecord.getRowNumber() < this.firstrow || this.firstrow == -1) {
            this.firstrow = rowRecord.getRowNumber();
        }
        if (rowRecord.getRowNumber() > this.lastrow || this.lastrow == -1) {
            this.lastrow = rowRecord.getRowNumber();
        }
    }

    public void removeRow(RowRecord rowRecord) {
        this.size -= rowRecord.getRecordSize();
        this.records.remove(rowRecord);
    }

    public RowRecord getRow(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("The row number must be between 0 and 65535");
        }
        RowRecord rowRecord = new RowRecord(n);
        return (RowRecord)this.records.get(rowRecord);
    }

    public int getPhysicalNumberOfRows() {
        return this.records.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public int getRowBlockCount() {
        int n = this.records.size() / 32;
        if (this.records.size() % 32 != 0) {
            ++n;
        }
        return n;
    }

    public int getRowBlockSize(int n) {
        return 20 * this.getRowCountForBlock(n);
    }

    public int getRowCountForBlock(int n) {
        int n2 = n * 32;
        int n3 = n2 + 32 - 1;
        if (n3 >= this.records.size()) {
            n3 = this.records.size() - 1;
        }
        return n3 - n2 + 1;
    }

    public int getStartRowNumberForBlock(int n) {
        int n2 = n * 32;
        Iterator iterator = this.records.values().iterator();
        RowRecord rowRecord = null;
        for (int i = 0; i <= n2; ++i) {
            rowRecord = (RowRecord)iterator.next();
        }
        return rowRecord.getRowNumber();
    }

    public int getEndRowNumberForBlock(int n) {
        int n2 = (n + 1) * 32 - 1;
        if (n2 >= this.records.size()) {
            n2 = this.records.size() - 1;
        }
        Iterator iterator = this.records.values().iterator();
        RowRecord rowRecord = null;
        for (int i = 0; i <= n2; ++i) {
            rowRecord = (RowRecord)iterator.next();
        }
        return rowRecord.getRowNumber();
    }

    private int serializeRowBlock(int n, int n2, byte[] byArray) {
        int n3;
        int n4 = n * 32;
        int n5 = n4 + 32;
        Iterator iterator = this.records.values().iterator();
        int n6 = n2;
        for (n3 = 0; n3 < n4; ++n3) {
            iterator.next();
        }
        while (iterator.hasNext() && n3++ < n5) {
            RowRecord rowRecord = (RowRecord)iterator.next();
            n6 += rowRecord.serialize(n6, byArray);
        }
        return n6 - n2;
    }

    public int serialize(int n, byte[] byArray) {
        throw new RuntimeException("The serialize method that passes in cells should be used");
    }

    public int serialize(int n, byte[] byArray, ValueRecordsAggregate valueRecordsAggregate) {
        int n2 = n;
        int n3 = this.getRowBlockCount();
        for (int i = 0; i < n3; ++i) {
            int n4 = n2;
            int n5 = this.serializeRowBlock(i, n2, byArray);
            n2 += n5;
            int n6 = this.getStartRowNumberForBlock(i);
            int n7 = this.getEndRowNumberForBlock(i);
            DBCellRecord dBCellRecord = new DBCellRecord();
            int n8 = n5 - 20;
            for (int j = n6; j <= n7; ++j) {
                if (null == valueRecordsAggregate || !valueRecordsAggregate.rowHasCells(j)) continue;
                int n9 = valueRecordsAggregate.serializeCellRow(j, n2, byArray);
                n2 += n9;
                dBCellRecord.addCellOffset((short)n8);
                n8 = n9;
            }
            dBCellRecord.setRowOffset(n2 - n4);
            n2 += dBCellRecord.serialize(n2, byArray);
        }
        return n2 - n;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
    }

    protected void validateSid(short s) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        return this.size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }

    public Object clone() {
        RowRecordsAggregate rowRecordsAggregate = new RowRecordsAggregate();
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            RowRecord rowRecord = (RowRecord)((RowRecord)iterator.next()).clone();
            rowRecordsAggregate.insertRow(rowRecord);
        }
        return rowRecordsAggregate;
    }

    public int findStartOfRowOutlineGroup(int n) {
        RowRecord rowRecord = this.getRow(n);
        short s = rowRecord.getOutlineLevel();
        int n2 = n;
        while (this.getRow(n2) != null) {
            rowRecord = this.getRow(n2);
            if (rowRecord.getOutlineLevel() < s) {
                return n2 + 1;
            }
            --n2;
        }
        return n2 + 1;
    }

    public int findEndOfRowOutlineGroup(int n) {
        int n2;
        short s = this.getRow(n).getOutlineLevel();
        for (n2 = n; n2 < this.getLastRowNum() && this.getRow(n2) != null && this.getRow(n2).getOutlineLevel() >= s; ++n2) {
        }
        return n2 - 1;
    }

    public int writeHidden(RowRecord rowRecord, int n, boolean bl) {
        short s = rowRecord.getOutlineLevel();
        while (rowRecord != null && this.getRow(n).getOutlineLevel() >= s) {
            rowRecord.setZeroHeight(bl);
            rowRecord = this.getRow(++n);
        }
        return n - 1;
    }

    public void collapseRow(int n) {
        int n2 = this.findStartOfRowOutlineGroup(n);
        RowRecord rowRecord = this.getRow(n2);
        int n3 = this.writeHidden(rowRecord, n2, true);
        if (this.getRow(n3 + 1) != null) {
            this.getRow(n3 + 1).setColapsed(true);
        } else {
            RowRecord rowRecord2 = RowRecordsAggregate.createRow(n3 + 1);
            rowRecord2.setColapsed(true);
            this.insertRow(rowRecord2);
        }
    }

    public static RowRecord createRow(int n) {
        return new RowRecord(n);
    }

    public boolean isRowGroupCollapsed(int n) {
        int n2 = this.findEndOfRowOutlineGroup(n) + 1;
        if (this.getRow(n2) == null) {
            return false;
        }
        return this.getRow(n2).getColapsed();
    }

    public void expandRow(int n) {
        int n2 = n;
        if (n2 == -1) {
            return;
        }
        if (!this.isRowGroupCollapsed(n2)) {
            return;
        }
        int n3 = this.findStartOfRowOutlineGroup(n2);
        RowRecord rowRecord = this.getRow(n3);
        int n4 = this.findEndOfRowOutlineGroup(n2);
        if (!this.isRowGroupHiddenByParent(n2)) {
            for (int i = n3; i <= n4; ++i) {
                if (rowRecord.getOutlineLevel() == this.getRow(i).getOutlineLevel()) {
                    this.getRow(i).setZeroHeight(false);
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).setZeroHeight(false);
            }
        }
        this.getRow(n4 + 1).setColapsed(false);
    }

    public boolean isRowGroupHiddenByParent(int n) {
        boolean bl;
        short s;
        boolean bl2;
        short s2;
        int n2 = this.findEndOfRowOutlineGroup(n);
        if (this.getRow(n2 + 1) == null) {
            s2 = 0;
            bl2 = false;
        } else {
            s2 = this.getRow(n2 + 1).getOutlineLevel();
            bl2 = this.getRow(n2 + 1).getZeroHeight();
        }
        int n3 = this.findStartOfRowOutlineGroup(n);
        if (n3 - 1 < 0 || this.getRow(n3 - 1) == null) {
            s = 0;
            bl = false;
        } else {
            s = this.getRow(n3 - 1).getOutlineLevel();
            bl = this.getRow(n3 - 1).getZeroHeight();
        }
        if (s2 > s) {
            return bl2;
        }
        return bl;
    }
}

