/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.aggregates;

import com.fr.third.org.apache.poi.hssf.record.ColumnInfoRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ColumnInfoRecordsAggregate
extends Record {
    List records = new ArrayList();

    protected void fillFields(RecordInputStream recordInputStream) {
    }

    protected void validateSid(short s) {
    }

    public short getSid() {
        return -1012;
    }

    public int getRecordSize() {
        int n = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            n += ((ColumnInfoRecord)iterator.next()).getRecordSize();
        }
        return n;
    }

    public Iterator getIterator() {
        return this.records.iterator();
    }

    public Object clone() {
        ColumnInfoRecordsAggregate columnInfoRecordsAggregate = new ColumnInfoRecordsAggregate();
        for (int i = 0; i < this.records.size(); ++i) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.records.get(i);
            columnInfoRecord = (ColumnInfoRecord)columnInfoRecord.clone();
            columnInfoRecordsAggregate.insertColumn(columnInfoRecord);
        }
        return columnInfoRecordsAggregate;
    }

    public void insertColumn(ColumnInfoRecord columnInfoRecord) {
        this.records.add(columnInfoRecord);
    }

    public void insertColumn(int n, ColumnInfoRecord columnInfoRecord) {
        this.records.add(n, columnInfoRecord);
    }

    public int getNumColumns() {
        return this.records.size();
    }

    public int serialize(int n, byte[] byArray) {
        Iterator iterator = this.records.iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            n2 += ((Record)iterator.next()).serialize(n2, byArray);
        }
        return n2 - n;
    }

    public int findStartOfColumnOutlineGroup(int n) {
        ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.records.get(n);
        short s = columnInfoRecord.getOutlineLevel();
        while (n != 0) {
            ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)this.records.get(n - 1);
            if (columnInfoRecord.getFirstColumn() - 1 != columnInfoRecord2.getLastColumn() || columnInfoRecord2.getOutlineLevel() < s) break;
            --n;
            columnInfoRecord = columnInfoRecord2;
        }
        return n;
    }

    public int findEndOfColumnOutlineGroup(int n) {
        ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.records.get(n);
        short s = columnInfoRecord.getOutlineLevel();
        while (n < this.records.size() - 1) {
            ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)this.records.get(n + 1);
            if (columnInfoRecord.getLastColumn() + 1 != columnInfoRecord2.getFirstColumn() || columnInfoRecord2.getOutlineLevel() < s) break;
            ++n;
            columnInfoRecord = columnInfoRecord2;
        }
        return n;
    }

    public ColumnInfoRecord getColInfo(int n) {
        return (ColumnInfoRecord)this.records.get(n);
    }

    public ColumnInfoRecord writeHidden(ColumnInfoRecord columnInfoRecord, int n, boolean bl) {
        short s = columnInfoRecord.getOutlineLevel();
        while (n < this.records.size()) {
            columnInfoRecord.setHidden(bl);
            if (n + 1 < this.records.size()) {
                ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)this.records.get(n + 1);
                if (columnInfoRecord.getLastColumn() + 1 != columnInfoRecord2.getFirstColumn() || columnInfoRecord2.getOutlineLevel() < s) break;
                columnInfoRecord = columnInfoRecord2;
            }
            ++n;
        }
        return columnInfoRecord;
    }

    public boolean isColumnGroupCollapsed(int n) {
        int n2 = this.findEndOfColumnOutlineGroup(n);
        if (n2 >= this.records.size()) {
            return false;
        }
        if (this.getColInfo(n2).getLastColumn() + 1 != this.getColInfo(n2 + 1).getFirstColumn()) {
            return false;
        }
        return this.getColInfo(n2 + 1).getCollapsed();
    }

    public boolean isColumnGroupHiddenByParent(int n) {
        boolean bl;
        short s;
        boolean bl2;
        short s2;
        int n2 = this.findEndOfColumnOutlineGroup(n);
        if (n2 >= this.records.size()) {
            s2 = 0;
            bl2 = false;
        } else if (this.getColInfo(n2).getLastColumn() + 1 != this.getColInfo(n2 + 1).getFirstColumn()) {
            s2 = 0;
            bl2 = false;
        } else {
            s2 = this.getColInfo(n2 + 1).getOutlineLevel();
            bl2 = this.getColInfo(n2 + 1).getHidden();
        }
        int n3 = this.findStartOfColumnOutlineGroup(n);
        if (n3 <= 0) {
            s = 0;
            bl = false;
        } else if (this.getColInfo(n3).getFirstColumn() - 1 != this.getColInfo(n3 - 1).getLastColumn()) {
            s = 0;
            bl = false;
        } else {
            s = this.getColInfo(n3 - 1).getOutlineLevel();
            bl = this.getColInfo(n3 - 1).getHidden();
        }
        if (s2 > s) {
            return bl2;
        }
        return bl;
    }

    public void collapseColumn(short s) {
        int n = this.findColumnIdx(s, 0);
        if (n == -1) {
            return;
        }
        ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.records.get(this.findStartOfColumnOutlineGroup(n));
        columnInfoRecord = this.writeHidden(columnInfoRecord, n, true);
        this.setColumn((short)(columnInfoRecord.getLastColumn() + 1), null, null, null, null, Boolean.TRUE);
    }

    public void expandColumn(short s) {
        int n = this.findColumnIdx(s, 0);
        if (n == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(n)) {
            return;
        }
        int n2 = this.findStartOfColumnOutlineGroup(n);
        ColumnInfoRecord columnInfoRecord = this.getColInfo(n2);
        int n3 = this.findEndOfColumnOutlineGroup(n);
        ColumnInfoRecord columnInfoRecord2 = this.getColInfo(n3);
        if (!this.isColumnGroupHiddenByParent(n)) {
            for (int i = n2; i <= n3; ++i) {
                if (columnInfoRecord.getOutlineLevel() != this.getColInfo(i).getOutlineLevel()) continue;
                this.getColInfo(i).setHidden(false);
            }
        }
        this.setColumn((short)(columnInfoRecord.getLastColumn() + 1), null, null, null, null, Boolean.FALSE);
    }

    public static Record createColInfo() {
        ColumnInfoRecord columnInfoRecord = new ColumnInfoRecord();
        columnInfoRecord.setColumnWidth((short)2275);
        columnInfoRecord.setOptions((short)2);
        columnInfoRecord.setXFIndex((short)15);
        return columnInfoRecord;
    }

    public void setColumn(short s, Short s2, Short s3, Integer n, Boolean bl, Boolean bl2) {
        ColumnInfoRecord columnInfoRecord = null;
        int n2 = 0;
        for (n2 = 0; n2 < this.records.size() && ((columnInfoRecord = (ColumnInfoRecord)this.records.get(n2)).getFirstColumn() > s || s > columnInfoRecord.getLastColumn()); ++n2) {
            columnInfoRecord = null;
        }
        if (columnInfoRecord != null) {
            boolean bl3;
            boolean bl4 = s2 != null && columnInfoRecord.getXFIndex() != s2.shortValue();
            boolean bl5 = s3 != null && columnInfoRecord.getColumnWidth() != s3.shortValue();
            boolean bl6 = n != null && columnInfoRecord.getOutlineLevel() != n.intValue();
            boolean bl7 = bl != null && columnInfoRecord.getHidden() != bl.booleanValue();
            boolean bl8 = bl2 != null && columnInfoRecord.getCollapsed() != bl2.booleanValue();
            boolean bl9 = bl3 = bl4 || bl5 || bl6 || bl7 || bl8;
            if (bl3) {
                if (columnInfoRecord.getFirstColumn() == s && columnInfoRecord.getLastColumn() == s) {
                    this.setColumnInfoFields(columnInfoRecord, s2, s3, n, bl, bl2);
                } else if (columnInfoRecord.getFirstColumn() == s || columnInfoRecord.getLastColumn() == s) {
                    if (columnInfoRecord.getFirstColumn() == s) {
                        columnInfoRecord.setFirstColumn((short)(s + 1));
                    } else {
                        columnInfoRecord.setLastColumn((short)(s - 1));
                    }
                    ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    columnInfoRecord2.setFirstColumn(s);
                    columnInfoRecord2.setLastColumn(s);
                    columnInfoRecord2.setOptions(columnInfoRecord.getOptions());
                    columnInfoRecord2.setXFIndex(columnInfoRecord.getXFIndex());
                    this.setColumnInfoFields(columnInfoRecord2, s2, s3, n, bl, bl2);
                    this.insertColumn(n2, columnInfoRecord2);
                } else {
                    short s4 = columnInfoRecord.getLastColumn();
                    columnInfoRecord.setLastColumn((short)(s - 1));
                    ColumnInfoRecord columnInfoRecord3 = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    columnInfoRecord3.setFirstColumn(s);
                    columnInfoRecord3.setLastColumn(s);
                    columnInfoRecord3.setOptions(columnInfoRecord.getOptions());
                    columnInfoRecord3.setXFIndex(columnInfoRecord.getXFIndex());
                    this.setColumnInfoFields(columnInfoRecord3, s2, s3, n, bl, bl2);
                    this.insertColumn(++n2, columnInfoRecord3);
                    columnInfoRecord3 = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    columnInfoRecord3.setFirstColumn((short)(s + 1));
                    columnInfoRecord3.setLastColumn(s4);
                    columnInfoRecord3.setOptions(columnInfoRecord.getOptions());
                    columnInfoRecord3.setXFIndex(columnInfoRecord.getXFIndex());
                    columnInfoRecord3.setColumnWidth(columnInfoRecord.getColumnWidth());
                    this.insertColumn(++n2, columnInfoRecord3);
                }
            }
        } else {
            ColumnInfoRecord columnInfoRecord4 = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
            columnInfoRecord4.setFirstColumn(s);
            columnInfoRecord4.setLastColumn(s);
            this.setColumnInfoFields(columnInfoRecord4, s2, s3, n, bl, bl2);
            this.insertColumn(n2, columnInfoRecord4);
        }
    }

    private void setColumnInfoFields(ColumnInfoRecord columnInfoRecord, Short s, Short s2, Integer n, Boolean bl, Boolean bl2) {
        if (s != null) {
            columnInfoRecord.setXFIndex(s);
        }
        if (s2 != null) {
            columnInfoRecord.setColumnWidth(s2);
        }
        if (n != null) {
            columnInfoRecord.setOutlineLevel(n.shortValue());
        }
        if (bl != null) {
            columnInfoRecord.setHidden(bl);
        }
        if (bl2 != null) {
            columnInfoRecord.setCollapsed(bl2);
        }
    }

    public int findColumnIdx(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + n2);
        }
        for (int i = n2; i < this.records.size(); ++i) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.records.get(i);
            if (columnInfoRecord.getFirstColumn() <= n && n <= columnInfoRecord.getLastColumn()) {
                return i;
            }
            columnInfoRecord = null;
        }
        return -1;
    }

    public void collapseColInfoRecords(int n) {
        boolean bl;
        boolean bl2;
        if (n == 0) {
            return;
        }
        ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.records.get(n - 1);
        ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)this.records.get(n);
        boolean bl3 = bl2 = columnInfoRecord.getLastColumn() == columnInfoRecord2.getFirstColumn() - 1;
        if (!bl2) {
            return;
        }
        boolean bl4 = bl = columnInfoRecord.getXFIndex() == columnInfoRecord2.getXFIndex() && columnInfoRecord.getOptions() == columnInfoRecord2.getOptions() && columnInfoRecord.getColumnWidth() == columnInfoRecord2.getColumnWidth();
        if (bl) {
            columnInfoRecord.setLastColumn(columnInfoRecord2.getLastColumn());
            this.records.remove(n);
        }
    }

    public void groupColumnRange(short n, short s, boolean bl) {
        int n2 = 0;
        for (int i = n; i <= s; ++i) {
            int n3 = 1;
            int n4 = this.findColumnIdx(i, Math.max(0, n2));
            if (n4 != -1) {
                n3 = ((ColumnInfoRecord)this.records.get(n4)).getOutlineLevel();
                n3 = bl ? ++n3 : --n3;
                n3 = Math.max(0, n3);
                n3 = Math.min(7, n3);
                n2 = n4 - 1;
            }
            this.setColumn((short)i, null, null, new Integer(n3), null, null);
            n4 = this.findColumnIdx(i, Math.max(0, n2));
            this.collapseColInfoRecords(n4);
        }
    }
}

