/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.aggregates;

import com.fr.third.org.apache.poi.hssf.record.CFHeaderRecord;
import com.fr.third.org.apache.poi.hssf.record.CFRuleRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.util.Region;
import com.fr.third.org.apache.poi.util.POILogFactory;
import com.fr.third.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CFRecordsAggregate
extends Record {
    private static final int MAX_CONDTIONAL_FORMAT_RULES = 3;
    public static final short sid = -2008;
    private static POILogger log = POILogFactory.getLogger(class$com$fr$third$org$apache$poi$hssf$record$aggregates$CFRecordsAggregate == null ? (class$com$fr$third$org$apache$poi$hssf$record$aggregates$CFRecordsAggregate = CFRecordsAggregate.class$("com.fr.third.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate")) : class$com$fr$third$org$apache$poi$hssf$record$aggregates$CFRecordsAggregate);
    private final CFHeaderRecord header;
    private final List rules;
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$aggregates$CFRecordsAggregate;

    private CFRecordsAggregate(CFHeaderRecord cFHeaderRecord, CFRuleRecord[] cFRuleRecordArray) {
        if (cFHeaderRecord == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (cFRuleRecordArray == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (cFRuleRecordArray.length > 3) {
            throw new IllegalArgumentException("No more than 3 rules may be specified");
        }
        this.header = cFHeaderRecord;
        this.rules = new ArrayList(3);
        for (int i = 0; i < cFRuleRecordArray.length; ++i) {
            this.rules.add(cFRuleRecordArray[i]);
        }
    }

    public CFRecordsAggregate(Region[] regionArray, CFRuleRecord[] cFRuleRecordArray) {
        this(new CFHeaderRecord(regionArray), cFRuleRecordArray);
    }

    public static CFRecordsAggregate createCFAggregate(List list, int n) {
        int n2;
        Record record = (Record)list.get(n);
        if (record.getSid() != 432) {
            throw new IllegalStateException("next record sid was " + record.getSid() + " instead of " + 432 + " as expected");
        }
        CFHeaderRecord cFHeaderRecord = (CFHeaderRecord)record;
        int n3 = cFHeaderRecord.getNumberOfConditionalFormats();
        CFRuleRecord[] cFRuleRecordArray = new CFRuleRecord[n3];
        int n4 = n;
        for (n2 = 0; n2 < cFRuleRecordArray.length && ++n4 < list.size() && (record = (Record)list.get(n4)) instanceof CFRuleRecord; ++n2) {
            cFRuleRecordArray[n2] = (CFRuleRecord)record;
        }
        if (n2 < n3) {
            if (log.check(1)) {
                log.log(1, "Expected  " + n3 + " Conditional Formats, " + "but found " + n2 + " rules");
            }
            cFHeaderRecord.setNumberOfConditionalFormats(n3);
            CFRuleRecord[] cFRuleRecordArray2 = new CFRuleRecord[n2];
            System.arraycopy(cFRuleRecordArray, 0, cFRuleRecordArray2, 0, n2);
            cFRuleRecordArray = cFRuleRecordArray2;
        }
        return new CFRecordsAggregate(cFHeaderRecord, cFRuleRecordArray);
    }

    public CFRecordsAggregate cloneCFAggregate() {
        CFRuleRecord[] cFRuleRecordArray = new CFRuleRecord[this.rules.size()];
        for (int i = 0; i < cFRuleRecordArray.length; ++i) {
            cFRuleRecordArray[i] = (CFRuleRecord)this.getRule(i).clone();
        }
        return new CFRecordsAggregate((CFHeaderRecord)this.header.clone(), cFRuleRecordArray);
    }

    protected void fillFields(RecordInputStream recordInputStream) {
    }

    public short getSid() {
        return -2008;
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = this.rules.size();
        this.header.setNumberOfConditionalFormats(n2);
        int n3 = n;
        n3 += this.header.serialize(n3, byArray);
        for (int i = 0; i < n2; ++i) {
            n3 += this.getRule(i).serialize(n3, byArray);
        }
        return n3 - n;
    }

    protected void validateSid(short s) {
    }

    public CFHeaderRecord getHeader() {
        return this.header;
    }

    private void checkRuleIndex(int n) {
        if (n < 0 || n >= this.rules.size()) {
            throw new IllegalArgumentException("Bad rule record index (" + n + ") nRules=" + this.rules.size());
        }
    }

    public CFRuleRecord getRule(int n) {
        this.checkRuleIndex(n);
        return (CFRuleRecord)this.rules.get(n);
    }

    public void setRule(int n, CFRuleRecord cFRuleRecord) {
        this.checkRuleIndex(n);
        this.rules.set(n, cFRuleRecord);
    }

    public void addRule(CFRuleRecord cFRuleRecord) {
        if (this.rules.size() >= 3) {
            throw new IllegalStateException("Cannot have more than 3 conditional format rules");
        }
        this.rules.add(cFRuleRecord);
        this.header.setNumberOfConditionalFormats(this.rules.size());
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public int getRecordSize() {
        int n = 0;
        if (this.header != null) {
            n += this.header.getRecordSize();
        }
        if (this.rules != null) {
            Iterator iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                n += ((Record)iterator.next()).getRecordSize();
            }
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CF]\n");
        if (this.header != null) {
            stringBuffer.append(this.header.toString());
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            CFRuleRecord cFRuleRecord = (CFRuleRecord)this.rules.get(i);
            if (cFRuleRecord == null) continue;
            stringBuffer.append(cFRuleRecord.toString());
        }
        stringBuffer.append("[/CF]\n");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

