/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class WriteAccessRecord
extends Record {
    public static final short sid = 92;
    private String field_1_username;

    public WriteAccessRecord() {
    }

    public WriteAccessRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 92) {
            throw new RecordFormatException("NOT A WRITEACCESS RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        byte[] byArray = recordInputStream.readRemainder();
        this.field_1_username = StringUtil.getFromCompressedUnicode(byArray, 3, byArray.length - 3);
    }

    public void setUsername(String string) {
        this.field_1_username = string;
    }

    public String getUsername() {
        return this.field_1_username;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WRITEACCESS]\n");
        stringBuffer.append("    .name            = ").append(this.field_1_username.toString()).append("\n");
        stringBuffer.append("[/WRITEACCESS]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        String string = this.getUsername();
        StringBuffer stringBuffer = new StringBuffer(109);
        stringBuffer.append(string);
        while (stringBuffer.length() < 109) {
            stringBuffer.append(" ");
        }
        string = stringBuffer.toString();
        UnicodeString unicodeString = new UnicodeString(string);
        unicodeString.setOptionFlags((byte)0);
        LittleEndian.putShort(byArray, 0 + n, (short)92);
        LittleEndian.putShort(byArray, 2 + n, (short)112);
        UnicodeString.UnicodeRecordStats unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
        unicodeRecordStats.recordSize += 4;
        unicodeRecordStats.remainingSize -= 4;
        unicodeString.serialize(unicodeRecordStats, 4 + n, byArray);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 116;
    }

    public short getSid() {
        return 92;
    }
}

