/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class WindowOneRecord
extends Record {
    public static final short sid = 61;
    private short field_1_h_hold;
    private short field_2_v_hold;
    private short field_3_width;
    private short field_4_height;
    private short field_5_options;
    private static final BitField hidden = BitFieldFactory.getInstance(1);
    private static final BitField iconic = BitFieldFactory.getInstance(2);
    private static final BitField reserved = BitFieldFactory.getInstance(4);
    private static final BitField hscroll = BitFieldFactory.getInstance(8);
    private static final BitField vscroll = BitFieldFactory.getInstance(16);
    private static final BitField tabs = BitFieldFactory.getInstance(32);
    private int field_6_active_sheet;
    private int field_7_first_visible_tab;
    private short field_8_num_selected_tabs;
    private short field_9_tab_width_ratio;

    public WindowOneRecord() {
    }

    public WindowOneRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 61) {
            throw new RecordFormatException("NOT A WINDOW1 RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_h_hold = recordInputStream.readShort();
        this.field_2_v_hold = recordInputStream.readShort();
        this.field_3_width = recordInputStream.readShort();
        this.field_4_height = recordInputStream.readShort();
        this.field_5_options = recordInputStream.readShort();
        this.field_6_active_sheet = recordInputStream.readShort();
        this.field_7_first_visible_tab = recordInputStream.readShort();
        this.field_8_num_selected_tabs = recordInputStream.readShort();
        this.field_9_tab_width_ratio = recordInputStream.readShort();
    }

    public void setHorizontalHold(short s) {
        this.field_1_h_hold = s;
    }

    public void setVerticalHold(short s) {
        this.field_2_v_hold = s;
    }

    public void setWidth(short s) {
        this.field_3_width = s;
    }

    public void setHeight(short s) {
        this.field_4_height = s;
    }

    public void setOptions(short s) {
        this.field_5_options = s;
    }

    public void setHidden(boolean bl) {
        this.field_5_options = hidden.setShortBoolean(this.field_5_options, bl);
    }

    public void setIconic(boolean bl) {
        this.field_5_options = iconic.setShortBoolean(this.field_5_options, bl);
    }

    public void setDisplayHorizonalScrollbar(boolean bl) {
        this.field_5_options = hscroll.setShortBoolean(this.field_5_options, bl);
    }

    public void setDisplayVerticalScrollbar(boolean bl) {
        this.field_5_options = vscroll.setShortBoolean(this.field_5_options, bl);
    }

    public void setDisplayTabs(boolean bl) {
        this.field_5_options = tabs.setShortBoolean(this.field_5_options, bl);
    }

    public void setActiveSheetIndex(int n) {
        this.field_6_active_sheet = n;
    }

    public void setSelectedTab(short s) {
        this.setActiveSheetIndex(s);
    }

    public void setFirstVisibleTab(int n) {
        this.field_7_first_visible_tab = n;
    }

    public void setDisplayedTab(short s) {
        this.setFirstVisibleTab(s);
    }

    public void setNumSelectedTabs(short s) {
        this.field_8_num_selected_tabs = s;
    }

    public void setTabWidthRatio(short s) {
        this.field_9_tab_width_ratio = s;
    }

    public short getHorizontalHold() {
        return this.field_1_h_hold;
    }

    public short getVerticalHold() {
        return this.field_2_v_hold;
    }

    public short getWidth() {
        return this.field_3_width;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean getHidden() {
        return hidden.isSet(this.field_5_options);
    }

    public boolean getIconic() {
        return iconic.isSet(this.field_5_options);
    }

    public boolean getDisplayHorizontalScrollbar() {
        return hscroll.isSet(this.field_5_options);
    }

    public boolean getDisplayVerticalScrollbar() {
        return vscroll.isSet(this.field_5_options);
    }

    public boolean getDisplayTabs() {
        return tabs.isSet(this.field_5_options);
    }

    public int getActiveSheetIndex() {
        return this.field_6_active_sheet;
    }

    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    public int getFirstVisibleTab() {
        return this.field_7_first_visible_tab;
    }

    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    public short getNumSelectedTabs() {
        return this.field_8_num_selected_tabs;
    }

    public short getTabWidthRatio() {
        return this.field_9_tab_width_ratio;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WINDOW1]\n");
        stringBuffer.append("    .h_hold          = ").append(Integer.toHexString(this.getHorizontalHold())).append("\n");
        stringBuffer.append("    .v_hold          = ").append(Integer.toHexString(this.getVerticalHold())).append("\n");
        stringBuffer.append("    .width           = ").append(Integer.toHexString(this.getWidth())).append("\n");
        stringBuffer.append("    .height          = ").append(Integer.toHexString(this.getHeight())).append("\n");
        stringBuffer.append("    .options         = ").append(Integer.toHexString(this.getOptions())).append("\n");
        stringBuffer.append("        .hidden      = ").append(this.getHidden()).append("\n");
        stringBuffer.append("        .iconic      = ").append(this.getIconic()).append("\n");
        stringBuffer.append("        .hscroll     = ").append(this.getDisplayHorizontalScrollbar()).append("\n");
        stringBuffer.append("        .vscroll     = ").append(this.getDisplayVerticalScrollbar()).append("\n");
        stringBuffer.append("        .tabs        = ").append(this.getDisplayTabs()).append("\n");
        stringBuffer.append("    .activeSheet     = ").append(Integer.toHexString(this.getActiveSheetIndex())).append("\n");
        stringBuffer.append("    .firstVisibleTab    = ").append(Integer.toHexString(this.getFirstVisibleTab())).append("\n");
        stringBuffer.append("    .numselectedtabs = ").append(Integer.toHexString(this.getNumSelectedTabs())).append("\n");
        stringBuffer.append("    .tabwidthratio   = ").append(Integer.toHexString(this.getTabWidthRatio())).append("\n");
        stringBuffer.append("[/WINDOW1]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)61);
        LittleEndian.putShort(byArray, 2 + n, (short)18);
        LittleEndian.putShort(byArray, 4 + n, this.getHorizontalHold());
        LittleEndian.putShort(byArray, 6 + n, this.getVerticalHold());
        LittleEndian.putShort(byArray, 8 + n, this.getWidth());
        LittleEndian.putShort(byArray, 10 + n, this.getHeight());
        LittleEndian.putShort(byArray, 12 + n, this.getOptions());
        LittleEndian.putUShort(byArray, 14 + n, this.getActiveSheetIndex());
        LittleEndian.putUShort(byArray, 16 + n, this.getFirstVisibleTab());
        LittleEndian.putShort(byArray, 18 + n, this.getNumSelectedTabs());
        LittleEndian.putShort(byArray, 20 + n, this.getTabWidthRatio());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 61;
    }
}

