/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class UseSelFSRecord
extends Record {
    public static final short sid = 352;
    public static final short TRUE = 1;
    public static final short FALSE = 0;
    private short field_1_flag;

    public UseSelFSRecord() {
    }

    public UseSelFSRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 352) {
            throw new RecordFormatException("NOT A UseSelFS RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_flag = recordInputStream.readShort();
    }

    public void setFlag(short s) {
        this.field_1_flag = s;
    }

    public short getFlag() {
        return this.field_1_flag;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[USESELFS]\n");
        stringBuffer.append("    .flag            = ").append(Integer.toHexString(this.getFlag())).append("\n");
        stringBuffer.append("[/USESELFS]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)352);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, this.getFlag());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 352;
    }
}

