/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class UnknownRecord
extends Record {
    private short sid = 0;
    private byte[] thedata = null;

    public UnknownRecord() {
    }

    public UnknownRecord(short s, byte[] byArray) {
        this.sid = s;
        this.thedata = byArray;
    }

    public UnknownRecord(RecordInputStream recordInputStream) {
        this.sid = recordInputStream.getSid();
        this.thedata = recordInputStream.readRemainder();
    }

    public int serialize(int n, byte[] byArray) {
        if (this.thedata == null) {
            this.thedata = new byte[0];
        }
        LittleEndian.putShort(byArray, 0 + n, this.sid);
        LittleEndian.putShort(byArray, 2 + n, (short)this.thedata.length);
        if (this.thedata.length > 0) {
            System.arraycopy(this.thedata, 0, byArray, 4 + n, this.thedata.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = 4;
        if (this.thedata != null) {
            n += this.thedata.length;
        }
        return n;
    }

    protected void fillFields(byte[] byArray, short s) {
        this.sid = s;
        this.thedata = byArray;
    }

    protected void validateSid(short s) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[UNKNOWN RECORD:" + Integer.toHexString(this.sid) + "]\n");
        stringBuffer.append("    .id        = ").append(Integer.toHexString(this.sid)).append("\n");
        stringBuffer.append("[/UNKNOWN RECORD]\n");
        return stringBuffer.toString();
    }

    public short getSid() {
        return this.sid;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        throw new RecordFormatException("Unknown record cannot be constructed via offset -- we need a copy of the data");
    }

    public Object clone() {
        UnknownRecord unknownRecord = new UnknownRecord();
        unknownRecord.sid = this.sid;
        unknownRecord.thedata = this.thedata;
        return unknownRecord;
    }
}

