/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class UnicodeString
implements Comparable {
    public static final short sid = 4095;
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private List field_4_format_runs;
    private byte[] field_5_ext_rst;
    private static final BitField highByte = BitFieldFactory.getInstance(1);
    private static final BitField extBit = BitFieldFactory.getInstance(4);
    private static final BitField richText = BitFieldFactory.getInstance(8);

    private UnicodeString() {
    }

    public UnicodeString(String string) {
        this.setString(string);
    }

    public UnicodeString(RecordInputStream recordInputStream) {
        this.validateSid(recordInputStream.getSid());
        this.fillFields(recordInputStream);
    }

    public int hashCode() {
        int n = 0;
        if (this.field_3_string != null) {
            n = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + n;
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        UnicodeString unicodeString = (UnicodeString)object;
        boolean bl2 = bl = this.field_1_charCount == unicodeString.field_1_charCount && this.field_2_optionflags == unicodeString.field_2_optionflags && this.field_3_string.equals(unicodeString.field_3_string);
        if (!bl) {
            return false;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs == null) {
            return true;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs != null || this.field_4_format_runs != null && unicodeString.field_4_format_runs == null) {
            return false;
        }
        int n2 = this.field_4_format_runs.size();
        if (n2 != unicodeString.field_4_format_runs.size()) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            FormatRun formatRun;
            FormatRun formatRun2 = (FormatRun)this.field_4_format_runs.get(n);
            if (formatRun2.equals(formatRun = (FormatRun)unicodeString.field_4_format_runs.get(n))) continue;
            return false;
        }
        if (this.field_5_ext_rst == null && unicodeString.field_5_ext_rst == null) {
            return true;
        }
        if (this.field_5_ext_rst == null && unicodeString.field_5_ext_rst != null || this.field_5_ext_rst != null && unicodeString.field_5_ext_rst == null) {
            return false;
        }
        n2 = this.field_5_ext_rst.length;
        if (n2 != this.field_5_ext_rst.length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.field_5_ext_rst[n] == unicodeString.field_5_ext_rst[n]) continue;
            return false;
        }
        return true;
    }

    protected void validateSid(short s) {
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        int n;
        boolean bl;
        this.field_1_charCount = recordInputStream.readShort();
        this.field_2_optionflags = recordInputStream.readByte();
        short s = 0;
        int n2 = 0;
        if (this.isRichText()) {
            s = recordInputStream.readShort();
        }
        if (this.isExtendedText()) {
            n2 = recordInputStream.readInt();
        }
        recordInputStream.setAutoContinue(false);
        StringBuffer stringBuffer = new StringBuffer(this.field_1_charCount);
        boolean bl2 = bl = (this.field_2_optionflags & 1) == 0;
        for (int i = this.field_1_charCount; i != 0; --i) {
            if (recordInputStream.remaining() == 0) {
                if (recordInputStream.isContinueNext()) {
                    recordInputStream.nextRecord();
                    n = recordInputStream.readByte();
                    bl = (n & '\u0001') == 0;
                } else {
                    throw new RecordFormatException("Expected continue record.");
                }
            }
            if (bl) {
                n = (char)(0xFF & (short)recordInputStream.readByte());
                stringBuffer.append((char)n);
                continue;
            }
            n = recordInputStream.readShort();
            stringBuffer.append((char)n);
        }
        this.field_3_string = stringBuffer.toString();
        recordInputStream.setAutoContinue(true);
        if (this.isRichText() && s > 0) {
            this.field_4_format_runs = new ArrayList(s);
            for (n = 0; n < s; ++n) {
                this.field_4_format_runs.add(new FormatRun(recordInputStream.readShort(), recordInputStream.readShort()));
            }
        }
        if (this.isExtendedText() && n2 > 0) {
            this.field_5_ext_rst = new byte[n2];
            for (n = 0; n < n2; ++n) {
                this.field_5_ext_rst[n] = recordInputStream.readByte();
            }
        }
    }

    public short getCharCount() {
        return this.field_1_charCount;
    }

    public void setCharCount(short s) {
        this.field_1_charCount = s;
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte by) {
        this.field_2_optionflags = by;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        this.setCharCount((short)this.field_3_string.length());
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            bl = true;
            break;
        }
        this.field_2_optionflags = bl ? highByte.setByte(this.field_2_optionflags) : highByte.clearByte(this.field_2_optionflags);
    }

    public int getFormatRunCount() {
        if (this.field_4_format_runs == null) {
            return 0;
        }
        return this.field_4_format_runs.size();
    }

    public FormatRun getFormatRun(int n) {
        if (this.field_4_format_runs == null) {
            return null;
        }
        if (n < 0 || n >= this.field_4_format_runs.size()) {
            return null;
        }
        return (FormatRun)this.field_4_format_runs.get(n);
    }

    private int findFormatRunAt(int n) {
        int n2 = this.field_4_format_runs.size();
        for (int i = 0; i < n2; ++i) {
            FormatRun formatRun = (FormatRun)this.field_4_format_runs.get(i);
            if (formatRun.character == n) {
                return i;
            }
            if (formatRun.character <= n) continue;
            return -1;
        }
        return -1;
    }

    public void addFormatRun(FormatRun formatRun) {
        int n;
        if (this.field_4_format_runs == null) {
            this.field_4_format_runs = new ArrayList();
        }
        if ((n = this.findFormatRunAt(formatRun.character)) != -1) {
            this.field_4_format_runs.remove(n);
        }
        this.field_4_format_runs.add(formatRun);
        Collections.sort(this.field_4_format_runs);
        this.field_2_optionflags = richText.setByte(this.field_2_optionflags);
    }

    public Iterator formatIterator() {
        if (this.field_4_format_runs != null) {
            return this.field_4_format_runs.iterator();
        }
        return null;
    }

    public void removeFormatRun(FormatRun formatRun) {
        this.field_4_format_runs.remove(formatRun);
        if (this.field_4_format_runs.size() == 0) {
            this.field_4_format_runs = null;
            this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
        }
    }

    public void clearFormatting() {
        this.field_4_format_runs = null;
        this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
    }

    public byte[] getExtendedRst() {
        return this.field_5_ext_rst;
    }

    public void setExtendedRst(byte[] byArray) {
        this.field_2_optionflags = byArray != null ? extBit.setByte(this.field_2_optionflags) : extBit.clearByte(this.field_2_optionflags);
        this.field_5_ext_rst = byArray;
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[UNICODESTRING]\n");
        stringBuffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        stringBuffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        stringBuffer.append("    .string          = ").append(this.getString()).append("\n");
        if (this.field_4_format_runs != null) {
            for (int i = 0; i < this.field_4_format_runs.size(); ++i) {
                FormatRun formatRun = (FormatRun)this.field_4_format_runs.get(i);
                stringBuffer.append("      .format_run" + i + "          = ").append(formatRun.toString()).append("\n");
            }
        }
        if (this.field_5_ext_rst != null) {
            stringBuffer.append("    .field_5_ext_rst          = ").append("\n").append(HexDump.toHex(this.field_5_ext_rst)).append("\n");
        }
        stringBuffer.append("[/UNICODESTRING]\n");
        return stringBuffer.toString();
    }

    private int writeContinueIfRequired(UnicodeRecordStats unicodeRecordStats, int n, int n2, byte[] byArray) {
        if (unicodeRecordStats.remainingSize < n) {
            if (unicodeRecordStats.lastLengthPos != -1) {
                short s = (short)(n2 - unicodeRecordStats.lastLengthPos - 2);
                if (s > 8224) {
                    throw new InternalError();
                }
                LittleEndian.putShort(byArray, unicodeRecordStats.lastLengthPos, s);
            }
            LittleEndian.putShort(byArray, n2, (short)60);
            unicodeRecordStats.lastLengthPos = n2 += 2;
            n2 += 2;
            unicodeRecordStats.recordSize += 4;
            unicodeRecordStats.remainingSize = 8224;
        }
        return n2;
    }

    public int serialize(UnicodeRecordStats unicodeRecordStats, int n, byte[] byArray) {
        int n2;
        int n3 = n;
        n3 = this.writeContinueIfRequired(unicodeRecordStats, 3, n3, byArray);
        LittleEndian.putShort(byArray, n3, this.getCharCount());
        byArray[n3 += 2] = this.getOptionFlags();
        ++n3;
        unicodeRecordStats.recordSize += 3;
        unicodeRecordStats.remainingSize -= 3;
        if (this.isRichText() && this.field_4_format_runs != null) {
            n3 = this.writeContinueIfRequired(unicodeRecordStats, 2, n3, byArray);
            LittleEndian.putShort(byArray, n3, (short)this.field_4_format_runs.size());
            n3 += 2;
            unicodeRecordStats.recordSize += 2;
            unicodeRecordStats.remainingSize -= 2;
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            n3 = this.writeContinueIfRequired(unicodeRecordStats, 4, n3, byArray);
            LittleEndian.putInt(byArray, n3, this.field_5_ext_rst.length);
            n3 += 4;
            unicodeRecordStats.recordSize += 4;
            unicodeRecordStats.remainingSize -= 4;
        }
        int n4 = this.isUncompressedUnicode() ? 2 : 1;
        int n5 = this.getString().length() * n4;
        byte[] byArray2 = null;
        try {
            String string = this.getString();
            byArray2 = !this.isUncompressedUnicode() ? string.getBytes("ISO-8859-1") : string.getBytes("UTF-16LE");
        }
        catch (Exception exception) {
            throw new InternalError();
        }
        if (n5 != byArray2.length) {
            throw new InternalError("That shouldnt have happened!");
        }
        if (n5 > unicodeRecordStats.remainingSize) {
            int n6 = n5;
            n2 = 0;
            while (n6 > 0) {
                int n7 = Math.min(unicodeRecordStats.remainingSize, n6);
                if (this.isUncompressedUnicode() && n7 % 2 == 1) {
                    --n7;
                }
                System.arraycopy(byArray2, n2, byArray, n3, n7);
                n3 += n7;
                n2 += n7;
                unicodeRecordStats.recordSize += n7;
                unicodeRecordStats.remainingSize -= n7;
                if ((n6 -= n7) <= 0) continue;
                n3 = this.writeContinueIfRequired(unicodeRecordStats, n6, n3, byArray);
                byArray[n3] = (byte)(this.isUncompressedUnicode() ? 1 : 0);
                ++n3;
                ++unicodeRecordStats.recordSize;
                --unicodeRecordStats.remainingSize;
            }
        } else {
            if (n5 > byArray.length - n3) {
                System.out.println("Hmm shouldnt happen");
            }
            System.arraycopy(byArray2, 0, byArray, n3, n5);
            n3 += n5;
            unicodeRecordStats.recordSize += n5;
            unicodeRecordStats.remainingSize -= n5;
        }
        if (this.isRichText() && this.field_4_format_runs != null) {
            int n8 = this.field_4_format_runs.size();
            for (n2 = 0; n2 < n8; ++n2) {
                n3 = this.writeContinueIfRequired(unicodeRecordStats, 4, n3, byArray);
                FormatRun formatRun = (FormatRun)this.field_4_format_runs.get(n2);
                LittleEndian.putShort(byArray, n3, formatRun.character);
                LittleEndian.putShort(byArray, n3 += 2, formatRun.fontIndex);
                n3 += 2;
                unicodeRecordStats.recordSize += 4;
                unicodeRecordStats.remainingSize -= 4;
            }
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            int n9 = this.field_5_ext_rst.length - unicodeRecordStats.remainingSize;
            n2 = 0;
            if (n9 > 0) {
                while (n9 > 0) {
                    int n10 = Math.min(unicodeRecordStats.remainingSize, n9);
                    System.arraycopy(this.field_5_ext_rst, n2, byArray, n3, n10);
                    n3 += n10;
                    n2 += n10;
                    unicodeRecordStats.recordSize += n10;
                    unicodeRecordStats.remainingSize -= n10;
                    if ((n9 -= n10) <= 0) continue;
                    n3 = this.writeContinueIfRequired(unicodeRecordStats, 1, n3, byArray);
                }
            } else {
                System.arraycopy(this.field_5_ext_rst, 0, byArray, n3, this.field_5_ext_rst.length);
                n3 += this.field_5_ext_rst.length;
                unicodeRecordStats.remainingSize -= this.field_5_ext_rst.length;
                unicodeRecordStats.recordSize += this.field_5_ext_rst.length;
            }
        }
        return n3 - n;
    }

    public void setCompressedUnicode() {
        this.field_2_optionflags = highByte.setByte(this.field_2_optionflags);
    }

    public void setUncompressedUnicode() {
        this.field_2_optionflags = highByte.clearByte(this.field_2_optionflags);
    }

    private boolean isUncompressedUnicode() {
        return highByte.isSet(this.getOptionFlags());
    }

    public void getRecordSize(UnicodeRecordStats unicodeRecordStats) {
        int n;
        int n2;
        if (unicodeRecordStats.remainingSize < 3) {
            unicodeRecordStats.recordSize += 4;
            unicodeRecordStats.remainingSize = 8224;
        }
        unicodeRecordStats.recordSize += 3;
        unicodeRecordStats.remainingSize -= 3;
        if (this.isRichText()) {
            if (unicodeRecordStats.remainingSize < 2) {
                unicodeRecordStats.remainingSize = 8224;
                unicodeRecordStats.recordSize += 4;
            }
            unicodeRecordStats.recordSize += 2;
            unicodeRecordStats.remainingSize -= 2;
        }
        if (this.isExtendedText()) {
            if (unicodeRecordStats.remainingSize < 4) {
                unicodeRecordStats.remainingSize = 8224;
                unicodeRecordStats.recordSize += 4;
            }
            unicodeRecordStats.recordSize += 4;
            unicodeRecordStats.remainingSize -= 4;
        }
        int n3 = this.isUncompressedUnicode() ? 2 : 1;
        int n4 = this.getString().length() * n3;
        if (n4 > unicodeRecordStats.remainingSize) {
            n2 = n4;
            while (n2 > 0) {
                n = Math.min(unicodeRecordStats.remainingSize, n2);
                if (this.isUncompressedUnicode() && n % 2 == 1) {
                    --n;
                }
                unicodeRecordStats.recordSize += n;
                unicodeRecordStats.remainingSize -= n;
                if ((n2 -= n) <= 0) continue;
                unicodeRecordStats.remainingSize = 8224;
                unicodeRecordStats.recordSize += 4;
                ++unicodeRecordStats.recordSize;
                --unicodeRecordStats.remainingSize;
            }
        } else {
            unicodeRecordStats.recordSize += n4;
            unicodeRecordStats.remainingSize -= n4;
        }
        if (this.isRichText() && this.field_4_format_runs != null) {
            n2 = this.field_4_format_runs.size();
            for (n = 0; n < n2; ++n) {
                if (unicodeRecordStats.remainingSize < 4) {
                    unicodeRecordStats.remainingSize = 8224;
                    unicodeRecordStats.recordSize += 4;
                }
                unicodeRecordStats.recordSize += 4;
                unicodeRecordStats.remainingSize -= 4;
            }
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            n2 = this.field_5_ext_rst.length - unicodeRecordStats.remainingSize;
            if (n2 > 0) {
                while (n2 > 0) {
                    n = Math.min(unicodeRecordStats.remainingSize, n2);
                    unicodeRecordStats.recordSize += n;
                    unicodeRecordStats.remainingSize -= n;
                    if ((n2 -= n) <= 0) continue;
                    unicodeRecordStats.remainingSize = 8224;
                    unicodeRecordStats.recordSize += 4;
                }
            } else {
                unicodeRecordStats.remainingSize -= this.field_5_ext_rst.length;
                unicodeRecordStats.recordSize += this.field_5_ext_rst.length;
            }
        }
    }

    public short getSid() {
        return 4095;
    }

    public int compareTo(Object object) {
        int n;
        UnicodeString unicodeString = (UnicodeString)object;
        int n2 = this.getString().compareTo(unicodeString.getString());
        if (n2 != 0) {
            return n2;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs == null) {
            return 0;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs != null) {
            return 1;
        }
        if (this.field_4_format_runs != null && unicodeString.field_4_format_runs == null) {
            return -1;
        }
        int n3 = this.field_4_format_runs.size();
        if (n3 != unicodeString.field_4_format_runs.size()) {
            return n3 - unicodeString.field_4_format_runs.size();
        }
        for (n = 0; n < n3; ++n) {
            FormatRun formatRun;
            FormatRun formatRun2 = (FormatRun)this.field_4_format_runs.get(n);
            n2 = formatRun2.compareTo(formatRun = (FormatRun)unicodeString.field_4_format_runs.get(n));
            if (n2 == 0) continue;
            return n2;
        }
        if (this.field_5_ext_rst == null && unicodeString.field_5_ext_rst == null) {
            return 0;
        }
        if (this.field_5_ext_rst == null && unicodeString.field_5_ext_rst != null) {
            return 1;
        }
        if (this.field_5_ext_rst != null && unicodeString.field_5_ext_rst == null) {
            return -1;
        }
        n3 = this.field_5_ext_rst.length;
        if (n3 != this.field_5_ext_rst.length) {
            return n3 - this.field_5_ext_rst.length;
        }
        for (n = 0; n < n3; ++n) {
            if (this.field_5_ext_rst[n] == unicodeString.field_5_ext_rst[n]) continue;
            return this.field_5_ext_rst[n] - unicodeString.field_5_ext_rst[n];
        }
        return 0;
    }

    public boolean isRichText() {
        return richText.isSet(this.getOptionFlags());
    }

    public boolean isExtendedText() {
        return extBit.isSet(this.getOptionFlags());
    }

    public Object clone() {
        UnicodeString unicodeString = new UnicodeString();
        unicodeString.field_1_charCount = this.field_1_charCount;
        unicodeString.field_2_optionflags = this.field_2_optionflags;
        unicodeString.field_3_string = this.field_3_string;
        if (this.field_4_format_runs != null) {
            unicodeString.field_4_format_runs = new ArrayList();
            int n = this.field_4_format_runs.size();
            for (int i = 0; i < n; ++i) {
                FormatRun formatRun = (FormatRun)this.field_4_format_runs.get(i);
                unicodeString.field_4_format_runs.add(new FormatRun(formatRun.character, formatRun.fontIndex));
            }
        }
        if (this.field_5_ext_rst != null) {
            unicodeString.field_5_ext_rst = new byte[this.field_5_ext_rst.length];
            System.arraycopy(this.field_5_ext_rst, 0, unicodeString.field_5_ext_rst, 0, this.field_5_ext_rst.length);
        }
        return unicodeString;
    }

    public static class UnicodeRecordStats {
        public int recordSize;
        public int remainingSize = 8228;
        public int lastLengthPos = -1;
    }

    public static class FormatRun
    implements Comparable {
        private short character;
        private short fontIndex;

        public FormatRun(short s, short s2) {
            this.character = s;
            this.fontIndex = s2;
        }

        public short getCharacterPos() {
            return this.character;
        }

        public short getFontIndex() {
            return this.fontIndex;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            FormatRun formatRun = (FormatRun)object;
            return this.character == formatRun.character && this.fontIndex == formatRun.fontIndex;
        }

        public int compareTo(Object object) {
            FormatRun formatRun = (FormatRun)object;
            if (this.character == formatRun.character && this.fontIndex == formatRun.fontIndex) {
                return 0;
            }
            if (this.character == formatRun.character) {
                return this.fontIndex - formatRun.fontIndex;
            }
            return this.character - formatRun.character;
        }

        public String toString() {
            return "character=" + this.character + ",fontIndex=" + this.fontIndex;
        }
    }
}

