/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class UncalcedRecord
extends Record {
    public static final short sid = 94;

    public UncalcedRecord() {
    }

    public UncalcedRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    public short getSid() {
        return 94;
    }

    protected void validateSid(short s) {
        if (s != 94) {
            throw new RecordFormatException("NOT AN UNCALCED RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        short s = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[UNCALCED]\n");
        stringBuffer.append("[/UNCALCED]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)94);
        LittleEndian.putShort(byArray, 2 + n, (short)2);
        LittleEndian.putShort(byArray, 4 + n, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return UncalcedRecord.getStaticRecordSize();
    }

    public static int getStaticRecordSize() {
        return 6;
    }
}

