/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class TickRecord
extends Record {
    public static final short sid = 4126;
    private byte field_1_majorTickType;
    private byte field_2_minorTickType;
    private byte field_3_labelPosition;
    private byte field_4_background;
    private int field_5_labelColorRgb;
    private int field_6_zero1;
    private int field_7_zero2;
    private int field_8_zero3;
    private int field_9_zero4;
    private short field_10_options;
    private BitField autoTextColor = BitFieldFactory.getInstance(1);
    private BitField autoTextBackground = BitFieldFactory.getInstance(2);
    private BitField rotation = BitFieldFactory.getInstance(28);
    private BitField autorotate = BitFieldFactory.getInstance(32);
    private short field_11_tickColor;
    private short field_12_zero5;

    public TickRecord() {
    }

    public TickRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4126) {
            throw new RecordFormatException("Not a Tick record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_majorTickType = recordInputStream.readByte();
        this.field_2_minorTickType = recordInputStream.readByte();
        this.field_3_labelPosition = recordInputStream.readByte();
        this.field_4_background = recordInputStream.readByte();
        this.field_5_labelColorRgb = recordInputStream.readInt();
        this.field_6_zero1 = recordInputStream.readInt();
        this.field_7_zero2 = recordInputStream.readInt();
        this.field_8_zero3 = recordInputStream.readInt();
        this.field_9_zero4 = recordInputStream.readInt();
        this.field_10_options = recordInputStream.readShort();
        this.field_11_tickColor = recordInputStream.readShort();
        this.field_12_zero5 = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TICK]\n");
        stringBuffer.append("    .majorTickType        = ").append("0x").append(HexDump.toHex(this.getMajorTickType())).append(" (").append(this.getMajorTickType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .minorTickType        = ").append("0x").append(HexDump.toHex(this.getMinorTickType())).append(" (").append(this.getMinorTickType()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .labelPosition        = ").append("0x").append(HexDump.toHex(this.getLabelPosition())).append(" (").append(this.getLabelPosition()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .background           = ").append("0x").append(HexDump.toHex(this.getBackground())).append(" (").append(this.getBackground()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .labelColorRgb        = ").append("0x").append(HexDump.toHex(this.getLabelColorRgb())).append(" (").append(this.getLabelColorRgb()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .zero1                = ").append("0x").append(HexDump.toHex(this.getZero1())).append(" (").append(this.getZero1()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .zero2                = ").append("0x").append(HexDump.toHex(this.getZero2())).append(" (").append(this.getZero2()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .autoTextColor            = ").append(this.isAutoTextColor()).append('\n');
        stringBuffer.append("         .autoTextBackground       = ").append(this.isAutoTextBackground()).append('\n');
        stringBuffer.append("         .rotation                 = ").append(this.getRotation()).append('\n');
        stringBuffer.append("         .autorotate               = ").append(this.isAutorotate()).append('\n');
        stringBuffer.append("    .tickColor            = ").append("0x").append(HexDump.toHex(this.getTickColor())).append(" (").append(this.getTickColor()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .zero3                = ").append("0x").append(HexDump.toHex(this.getZero3())).append(" (").append(this.getZero3()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/TICK]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4126);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        byArray[4 + n + n2] = this.field_1_majorTickType;
        byArray[5 + n + n2] = this.field_2_minorTickType;
        byArray[6 + n + n2] = this.field_3_labelPosition;
        byArray[7 + n + n2] = this.field_4_background;
        LittleEndian.putInt(byArray, 8 + n + n2, this.field_5_labelColorRgb);
        LittleEndian.putInt(byArray, 12 + n + n2, this.field_6_zero1);
        LittleEndian.putInt(byArray, 16 + n + n2, this.field_7_zero2);
        LittleEndian.putInt(byArray, 20 + n + n2, this.field_8_zero3);
        LittleEndian.putInt(byArray, 24 + n + n2, this.field_9_zero4);
        LittleEndian.putShort(byArray, 28 + n + n2, this.field_10_options);
        LittleEndian.putShort(byArray, 30 + n + n2, this.field_11_tickColor);
        LittleEndian.putShort(byArray, 32 + n + n2, this.field_12_zero5);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 34;
    }

    public short getSid() {
        return 4126;
    }

    public Object clone() {
        TickRecord tickRecord = new TickRecord();
        tickRecord.field_1_majorTickType = this.field_1_majorTickType;
        tickRecord.field_2_minorTickType = this.field_2_minorTickType;
        tickRecord.field_3_labelPosition = this.field_3_labelPosition;
        tickRecord.field_4_background = this.field_4_background;
        tickRecord.field_5_labelColorRgb = this.field_5_labelColorRgb;
        tickRecord.field_6_zero1 = this.field_6_zero1;
        tickRecord.field_7_zero2 = this.field_7_zero2;
        tickRecord.field_8_zero3 = this.field_8_zero3;
        tickRecord.field_9_zero4 = this.field_9_zero4;
        tickRecord.field_10_options = this.field_10_options;
        tickRecord.field_11_tickColor = this.field_11_tickColor;
        tickRecord.field_12_zero5 = this.field_12_zero5;
        return tickRecord;
    }

    public byte getMajorTickType() {
        return this.field_1_majorTickType;
    }

    public void setMajorTickType(byte by) {
        this.field_1_majorTickType = by;
    }

    public byte getMinorTickType() {
        return this.field_2_minorTickType;
    }

    public void setMinorTickType(byte by) {
        this.field_2_minorTickType = by;
    }

    public byte getLabelPosition() {
        return this.field_3_labelPosition;
    }

    public void setLabelPosition(byte by) {
        this.field_3_labelPosition = by;
    }

    public byte getBackground() {
        return this.field_4_background;
    }

    public void setBackground(byte by) {
        this.field_4_background = by;
    }

    public int getLabelColorRgb() {
        return this.field_5_labelColorRgb;
    }

    public void setLabelColorRgb(int n) {
        this.field_5_labelColorRgb = n;
    }

    public int getZero1() {
        return this.field_6_zero1;
    }

    public void setZero1(int n) {
        this.field_6_zero1 = n;
    }

    public int getZero2() {
        return this.field_7_zero2;
    }

    public void setZero2(int n) {
        this.field_7_zero2 = n;
    }

    public short getOptions() {
        return this.field_10_options;
    }

    public void setOptions(short s) {
        this.field_10_options = s;
    }

    public short getTickColor() {
        return this.field_11_tickColor;
    }

    public void setTickColor(short s) {
        this.field_11_tickColor = s;
    }

    public short getZero3() {
        return this.field_12_zero5;
    }

    public void setZero3(short s) {
        this.field_12_zero5 = s;
    }

    public void setAutoTextColor(boolean bl) {
        this.field_10_options = this.autoTextColor.setShortBoolean(this.field_10_options, bl);
    }

    public boolean isAutoTextColor() {
        return this.autoTextColor.isSet(this.field_10_options);
    }

    public void setAutoTextBackground(boolean bl) {
        this.field_10_options = this.autoTextBackground.setShortBoolean(this.field_10_options, bl);
    }

    public boolean isAutoTextBackground() {
        return this.autoTextBackground.isSet(this.field_10_options);
    }

    public void setRotation(short s) {
        this.field_10_options = this.rotation.setShortValue(this.field_10_options, s);
    }

    public short getRotation() {
        return this.rotation.getShortValue(this.field_10_options);
    }

    public void setAutorotate(boolean bl) {
        this.field_10_options = this.autorotate.setShortBoolean(this.field_10_options, bl);
    }

    public boolean isAutorotate() {
        return this.autorotate.isSet(this.field_10_options);
    }
}

