/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class TextRecord
extends Record {
    public static final short sid = 4133;
    private byte field_1_horizontalAlignment;
    public static final byte HORIZONTAL_ALIGNMENT_LEFT = 1;
    public static final byte HORIZONTAL_ALIGNMENT_CENTER = 2;
    public static final byte HORIZONTAL_ALIGNMENT_BOTTOM = 3;
    public static final byte HORIZONTAL_ALIGNMENT_JUSTIFY = 4;
    private byte field_2_verticalAlignment;
    public static final byte VERTICAL_ALIGNMENT_TOP = 1;
    public static final byte VERTICAL_ALIGNMENT_CENTER = 2;
    public static final byte VERTICAL_ALIGNMENT_BOTTOM = 3;
    public static final byte VERTICAL_ALIGNMENT_JUSTIFY = 4;
    private short field_3_displayMode;
    public static final short DISPLAY_MODE_TRANSPARENT = 1;
    public static final short DISPLAY_MODE_OPAQUE = 2;
    private int field_4_rgbColor;
    private int field_5_x;
    private int field_6_y;
    private int field_7_width;
    private int field_8_height;
    private short field_9_options1;
    private BitField autoColor = BitFieldFactory.getInstance(1);
    private BitField showKey = BitFieldFactory.getInstance(2);
    private BitField showValue = BitFieldFactory.getInstance(4);
    private BitField vertical = BitFieldFactory.getInstance(8);
    private BitField autoGeneratedText = BitFieldFactory.getInstance(16);
    private BitField generated = BitFieldFactory.getInstance(32);
    private BitField autoLabelDeleted = BitFieldFactory.getInstance(64);
    private BitField autoBackground = BitFieldFactory.getInstance(128);
    private BitField rotation = BitFieldFactory.getInstance(1792);
    public static final short ROTATION_NONE = 0;
    public static final short ROTATION_TOP_TO_BOTTOM = 1;
    public static final short ROTATION_ROTATED_90_DEGREES = 2;
    public static final short ROTATION_ROTATED_90_DEGREES_CLOCKWISE = 3;
    private BitField showCategoryLabelAsPercentage = BitFieldFactory.getInstance(2048);
    private BitField showValueAsPercentage = BitFieldFactory.getInstance(4096);
    private BitField showBubbleSizes = BitFieldFactory.getInstance(8192);
    private BitField showLabel = BitFieldFactory.getInstance(16384);
    private short field_10_indexOfColorValue;
    private short field_11_options2;
    private BitField dataLabelPlacement = BitFieldFactory.getInstance(15);
    public static final short DATA_LABEL_PLACEMENT_CHART_DEPENDENT = 0;
    public static final short DATA_LABEL_PLACEMENT_OUTSIDE = 1;
    public static final short DATA_LABEL_PLACEMENT_INSIDE = 2;
    public static final short DATA_LABEL_PLACEMENT_CENTER = 3;
    public static final short DATA_LABEL_PLACEMENT_AXIS = 4;
    public static final short DATA_LABEL_PLACEMENT_ABOVE = 5;
    public static final short DATA_LABEL_PLACEMENT_BELOW = 6;
    public static final short DATA_LABEL_PLACEMENT_LEFT = 7;
    public static final short DATA_LABEL_PLACEMENT_RIGHT = 8;
    public static final short DATA_LABEL_PLACEMENT_AUTO = 9;
    public static final short DATA_LABEL_PLACEMENT_USER_MOVED = 10;
    private short field_12_textRotation;

    public TextRecord() {
    }

    public TextRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4133) {
            throw new RecordFormatException("Not a Text record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_horizontalAlignment = recordInputStream.readByte();
        this.field_2_verticalAlignment = recordInputStream.readByte();
        this.field_3_displayMode = recordInputStream.readShort();
        this.field_4_rgbColor = recordInputStream.readInt();
        this.field_5_x = recordInputStream.readInt();
        this.field_6_y = recordInputStream.readInt();
        this.field_7_width = recordInputStream.readInt();
        this.field_8_height = recordInputStream.readInt();
        this.field_9_options1 = recordInputStream.readShort();
        this.field_10_indexOfColorValue = recordInputStream.readShort();
        this.field_11_options2 = recordInputStream.readShort();
        this.field_12_textRotation = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TEXT]\n");
        stringBuffer.append("    .horizontalAlignment  = ").append("0x").append(HexDump.toHex(this.getHorizontalAlignment())).append(" (").append(this.getHorizontalAlignment()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .verticalAlignment    = ").append("0x").append(HexDump.toHex(this.getVerticalAlignment())).append(" (").append(this.getVerticalAlignment()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .displayMode          = ").append("0x").append(HexDump.toHex(this.getDisplayMode())).append(" (").append(this.getDisplayMode()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .rgbColor             = ").append("0x").append(HexDump.toHex(this.getRgbColor())).append(" (").append(this.getRgbColor()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .x                    = ").append("0x").append(HexDump.toHex(this.getX())).append(" (").append(this.getX()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .y                    = ").append("0x").append(HexDump.toHex(this.getY())).append(" (").append(this.getY()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .width                = ").append("0x").append(HexDump.toHex(this.getWidth())).append(" (").append(this.getWidth()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .height               = ").append("0x").append(HexDump.toHex(this.getHeight())).append(" (").append(this.getHeight()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options1             = ").append("0x").append(HexDump.toHex(this.getOptions1())).append(" (").append(this.getOptions1()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .autoColor                = ").append(this.isAutoColor()).append('\n');
        stringBuffer.append("         .showKey                  = ").append(this.isShowKey()).append('\n');
        stringBuffer.append("         .showValue                = ").append(this.isShowValue()).append('\n');
        stringBuffer.append("         .vertical                 = ").append(this.isVertical()).append('\n');
        stringBuffer.append("         .autoGeneratedText        = ").append(this.isAutoGeneratedText()).append('\n');
        stringBuffer.append("         .generated                = ").append(this.isGenerated()).append('\n');
        stringBuffer.append("         .autoLabelDeleted         = ").append(this.isAutoLabelDeleted()).append('\n');
        stringBuffer.append("         .autoBackground           = ").append(this.isAutoBackground()).append('\n');
        stringBuffer.append("         .rotation                 = ").append(this.getRotation()).append('\n');
        stringBuffer.append("         .showCategoryLabelAsPercentage     = ").append(this.isShowCategoryLabelAsPercentage()).append('\n');
        stringBuffer.append("         .showValueAsPercentage     = ").append(this.isShowValueAsPercentage()).append('\n');
        stringBuffer.append("         .showBubbleSizes          = ").append(this.isShowBubbleSizes()).append('\n');
        stringBuffer.append("         .showLabel                = ").append(this.isShowLabel()).append('\n');
        stringBuffer.append("    .indexOfColorValue    = ").append("0x").append(HexDump.toHex(this.getIndexOfColorValue())).append(" (").append(this.getIndexOfColorValue()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .options2             = ").append("0x").append(HexDump.toHex(this.getOptions2())).append(" (").append(this.getOptions2()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .dataLabelPlacement       = ").append(this.getDataLabelPlacement()).append('\n');
        stringBuffer.append("    .textRotation         = ").append("0x").append(HexDump.toHex(this.getTextRotation())).append(" (").append(this.getTextRotation()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/TEXT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4133);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        byArray[4 + n + n2] = this.field_1_horizontalAlignment;
        byArray[5 + n + n2] = this.field_2_verticalAlignment;
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_3_displayMode);
        LittleEndian.putInt(byArray, 8 + n + n2, this.field_4_rgbColor);
        LittleEndian.putInt(byArray, 12 + n + n2, this.field_5_x);
        LittleEndian.putInt(byArray, 16 + n + n2, this.field_6_y);
        LittleEndian.putInt(byArray, 20 + n + n2, this.field_7_width);
        LittleEndian.putInt(byArray, 24 + n + n2, this.field_8_height);
        LittleEndian.putShort(byArray, 28 + n + n2, this.field_9_options1);
        LittleEndian.putShort(byArray, 30 + n + n2, this.field_10_indexOfColorValue);
        LittleEndian.putShort(byArray, 32 + n + n2, this.field_11_options2);
        LittleEndian.putShort(byArray, 34 + n + n2, this.field_12_textRotation);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 36;
    }

    public short getSid() {
        return 4133;
    }

    public Object clone() {
        TextRecord textRecord = new TextRecord();
        textRecord.field_1_horizontalAlignment = this.field_1_horizontalAlignment;
        textRecord.field_2_verticalAlignment = this.field_2_verticalAlignment;
        textRecord.field_3_displayMode = this.field_3_displayMode;
        textRecord.field_4_rgbColor = this.field_4_rgbColor;
        textRecord.field_5_x = this.field_5_x;
        textRecord.field_6_y = this.field_6_y;
        textRecord.field_7_width = this.field_7_width;
        textRecord.field_8_height = this.field_8_height;
        textRecord.field_9_options1 = this.field_9_options1;
        textRecord.field_10_indexOfColorValue = this.field_10_indexOfColorValue;
        textRecord.field_11_options2 = this.field_11_options2;
        textRecord.field_12_textRotation = this.field_12_textRotation;
        return textRecord;
    }

    public byte getHorizontalAlignment() {
        return this.field_1_horizontalAlignment;
    }

    public void setHorizontalAlignment(byte by) {
        this.field_1_horizontalAlignment = by;
    }

    public byte getVerticalAlignment() {
        return this.field_2_verticalAlignment;
    }

    public void setVerticalAlignment(byte by) {
        this.field_2_verticalAlignment = by;
    }

    public short getDisplayMode() {
        return this.field_3_displayMode;
    }

    public void setDisplayMode(short s) {
        this.field_3_displayMode = s;
    }

    public int getRgbColor() {
        return this.field_4_rgbColor;
    }

    public void setRgbColor(int n) {
        this.field_4_rgbColor = n;
    }

    public int getX() {
        return this.field_5_x;
    }

    public void setX(int n) {
        this.field_5_x = n;
    }

    public int getY() {
        return this.field_6_y;
    }

    public void setY(int n) {
        this.field_6_y = n;
    }

    public int getWidth() {
        return this.field_7_width;
    }

    public void setWidth(int n) {
        this.field_7_width = n;
    }

    public int getHeight() {
        return this.field_8_height;
    }

    public void setHeight(int n) {
        this.field_8_height = n;
    }

    public short getOptions1() {
        return this.field_9_options1;
    }

    public void setOptions1(short s) {
        this.field_9_options1 = s;
    }

    public short getIndexOfColorValue() {
        return this.field_10_indexOfColorValue;
    }

    public void setIndexOfColorValue(short s) {
        this.field_10_indexOfColorValue = s;
    }

    public short getOptions2() {
        return this.field_11_options2;
    }

    public void setOptions2(short s) {
        this.field_11_options2 = s;
    }

    public short getTextRotation() {
        return this.field_12_textRotation;
    }

    public void setTextRotation(short s) {
        this.field_12_textRotation = s;
    }

    public void setAutoColor(boolean bl) {
        this.field_9_options1 = this.autoColor.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isAutoColor() {
        return this.autoColor.isSet(this.field_9_options1);
    }

    public void setShowKey(boolean bl) {
        this.field_9_options1 = this.showKey.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isShowKey() {
        return this.showKey.isSet(this.field_9_options1);
    }

    public void setShowValue(boolean bl) {
        this.field_9_options1 = this.showValue.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isShowValue() {
        return this.showValue.isSet(this.field_9_options1);
    }

    public void setVertical(boolean bl) {
        this.field_9_options1 = this.vertical.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isVertical() {
        return this.vertical.isSet(this.field_9_options1);
    }

    public void setAutoGeneratedText(boolean bl) {
        this.field_9_options1 = this.autoGeneratedText.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isAutoGeneratedText() {
        return this.autoGeneratedText.isSet(this.field_9_options1);
    }

    public void setGenerated(boolean bl) {
        this.field_9_options1 = this.generated.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isGenerated() {
        return this.generated.isSet(this.field_9_options1);
    }

    public void setAutoLabelDeleted(boolean bl) {
        this.field_9_options1 = this.autoLabelDeleted.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isAutoLabelDeleted() {
        return this.autoLabelDeleted.isSet(this.field_9_options1);
    }

    public void setAutoBackground(boolean bl) {
        this.field_9_options1 = this.autoBackground.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isAutoBackground() {
        return this.autoBackground.isSet(this.field_9_options1);
    }

    public void setRotation(short s) {
        this.field_9_options1 = this.rotation.setShortValue(this.field_9_options1, s);
    }

    public short getRotation() {
        return this.rotation.getShortValue(this.field_9_options1);
    }

    public void setShowCategoryLabelAsPercentage(boolean bl) {
        this.field_9_options1 = this.showCategoryLabelAsPercentage.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isShowCategoryLabelAsPercentage() {
        return this.showCategoryLabelAsPercentage.isSet(this.field_9_options1);
    }

    public void setShowValueAsPercentage(boolean bl) {
        this.field_9_options1 = this.showValueAsPercentage.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isShowValueAsPercentage() {
        return this.showValueAsPercentage.isSet(this.field_9_options1);
    }

    public void setShowBubbleSizes(boolean bl) {
        this.field_9_options1 = this.showBubbleSizes.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isShowBubbleSizes() {
        return this.showBubbleSizes.isSet(this.field_9_options1);
    }

    public void setShowLabel(boolean bl) {
        this.field_9_options1 = this.showLabel.setShortBoolean(this.field_9_options1, bl);
    }

    public boolean isShowLabel() {
        return this.showLabel.isSet(this.field_9_options1);
    }

    public void setDataLabelPlacement(short s) {
        this.field_11_options2 = this.dataLabelPlacement.setShortValue(this.field_11_options2, s);
    }

    public short getDataLabelPlacement() {
        return this.dataLabelPlacement.getShortValue(this.field_11_options2);
    }
}

