/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.ContinueRecord;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.TextObjectBaseRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import java.io.UnsupportedEncodingException;

public class TextObjectRecord
extends TextObjectBaseRecord {
    HSSFRichTextString str;

    public TextObjectRecord() {
    }

    public TextObjectRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        if (this.str == null) {
            this.str = new HSSFRichTextString("");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        super.fillFields(recordInputStream);
        if (this.getTextLength() > 0) {
            if (recordInputStream.isContinueNext() && recordInputStream.remaining() == 0) {
                recordInputStream.nextRecord();
                this.processRawString(recordInputStream);
            } else {
                throw new RecordFormatException("Expected Continue record to hold string data for TextObjectRecord");
            }
        }
        if (this.getFormattingRunLength() > 0) {
            if (recordInputStream.isContinueNext() && recordInputStream.remaining() == 0) {
                recordInputStream.nextRecord();
                this.processFontRuns(recordInputStream);
            } else {
                throw new RecordFormatException("Expected Continue Record to hold font runs for TextObjectRecord");
            }
        }
    }

    public int getRecordSize() {
        int n = 0;
        int n2 = 0;
        if (this.str.length() != 0) {
            int n3 = this.str.length() * 2;
            while (n3 > 0) {
                int n4 = Math.min(8222, n3);
                n3 -= n4;
                n += n4;
                n += 5;
            }
            n2 = (this.str.numFormattingRuns() + 1) * 8 + 4;
        }
        return super.getRecordSize() + n + n2;
    }

    public int serialize(int n, byte[] byArray) {
        HSSFRichTextString hSSFRichTextString = this.str;
        this.str = new HSSFRichTextString("");
        int n2 = super.serialize(n, byArray);
        this.str = hSSFRichTextString;
        int n3 = n + n2;
        if (!this.str.getString().equals("")) {
            int n4;
            ContinueRecord continueRecord = this.createContinue2();
            int n5 = 0;
            try {
                byte[] byArray2 = this.str.getString().getBytes("UTF-16LE");
                n4 = byArray2.length;
                int n6 = 0;
                int n7 = n3;
                while (n4 > 0) {
                    int n8 = Math.min(8222, n4);
                    n4 -= n8;
                    LittleEndian.putShort(byArray, n7, (short)60);
                    LittleEndian.putShort(byArray, n7 += 2, (short)(n8 + 1));
                    byArray[n7 += 2] = 1;
                    System.arraycopy(byArray2, n6, byArray, ++n7, n8);
                    n7 += n8;
                    n6 += n8;
                }
                n5 = n7 - n3;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            int n9 = continueRecord.serialize(n3 += n5, byArray);
            n3 += n9;
            n4 = n2 + n5 + n9;
            if (n4 != this.getRecordSize()) {
                throw new RecordFormatException(n4 + " bytes written but getRecordSize() reports " + this.getRecordSize());
            }
            return n4;
        }
        if (n2 != this.getRecordSize()) {
            throw new RecordFormatException(n2 + " bytes written but getRecordSize() reports " + this.getRecordSize());
        }
        return n2;
    }

    private ContinueRecord createContinue2() {
        ContinueRecord continueRecord = new ContinueRecord();
        byte[] byArray = new byte[this.str.numFormattingRuns() * 8 + 8];
        int n = 0;
        for (int i = 0; i < this.str.numFormattingRuns(); ++i) {
            LittleEndian.putShort(byArray, n, (short)this.str.getIndexOfFormattingRun(i));
            LittleEndian.putShort(byArray, n += 2, this.str.getFontOfFormattingRun(i) == 0 ? (short)0 : this.str.getFontOfFormattingRun(i));
            n += 2;
            n += 4;
        }
        LittleEndian.putShort(byArray, n, (short)this.str.length());
        LittleEndian.putShort(byArray, n += 2, (short)0);
        n += 2;
        n += 4;
        continueRecord.setData(byArray);
        return continueRecord;
    }

    private void processFontRuns(RecordInputStream recordInputStream) {
        while (recordInputStream.remaining() > 0) {
            short s = recordInputStream.readShort();
            short s2 = recordInputStream.readShort();
            recordInputStream.readInt();
            this.str.applyFont((int)s, this.str.length(), s2);
        }
    }

    private void processRawString(RecordInputStream recordInputStream) {
        byte by = recordInputStream.readByte();
        boolean bl = by == 0;
        String string = bl ? recordInputStream.readCompressedUnicode(this.getTextLength()) : recordInputStream.readUnicodeLEString(this.getTextLength());
        this.str = new HSSFRichTextString(string);
    }

    public HSSFRichTextString getStr() {
        return this.str;
    }

    public void setStr(HSSFRichTextString hSSFRichTextString) {
        this.str = hSSFRichTextString;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TXO]\n");
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .reserved1                = ").append(this.isReserved1()).append('\n');
        stringBuffer.append("         .HorizontalTextAlignment     = ").append(this.getHorizontalTextAlignment()).append('\n');
        stringBuffer.append("         .VerticalTextAlignment     = ").append(this.getVerticalTextAlignment()).append('\n');
        stringBuffer.append("         .reserved2                = ").append(this.getReserved2()).append('\n');
        stringBuffer.append("         .textLocked               = ").append(this.isTextLocked()).append('\n');
        stringBuffer.append("         .reserved3                = ").append(this.getReserved3()).append('\n');
        stringBuffer.append("    .textOrientation      = ").append("0x").append(HexDump.toHex(this.getTextOrientation())).append(" (").append(this.getTextOrientation()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved4            = ").append("0x").append(HexDump.toHex(this.getReserved4())).append(" (").append(this.getReserved4()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved5            = ").append("0x").append(HexDump.toHex(this.getReserved5())).append(" (").append(this.getReserved5()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved6            = ").append("0x").append(HexDump.toHex(this.getReserved6())).append(" (").append(this.getReserved6()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .textLength           = ").append("0x").append(HexDump.toHex(this.getTextLength())).append(" (").append(this.getTextLength()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved7            = ").append("0x").append(HexDump.toHex(this.getReserved7())).append(" (").append(this.getReserved7()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .string = ").append(this.str).append('\n');
        for (int i = 0; i < this.str.numFormattingRuns(); ++i) {
            stringBuffer.append("    .textrun = ").append(this.str.getFontOfFormattingRun(i)).append('\n');
        }
        stringBuffer.append("[/TXO]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        TextObjectRecord textObjectRecord = new TextObjectRecord();
        textObjectRecord.str = this.str;
        textObjectRecord.setOptions(this.getOptions());
        textObjectRecord.setTextOrientation(this.getTextOrientation());
        textObjectRecord.setReserved4(this.getReserved4());
        textObjectRecord.setReserved5(this.getReserved5());
        textObjectRecord.setReserved6(this.getReserved6());
        textObjectRecord.setTextLength(this.getTextLength());
        textObjectRecord.setFormattingRunLength(this.getFormattingRunLength());
        textObjectRecord.setReserved7(this.getReserved7());
        return textObjectRecord;
    }
}

