/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class TextObjectBaseRecord
extends Record {
    public static final short sid = 438;
    private short field_1_options;
    private BitField reserved1 = BitFieldFactory.getInstance(1);
    private BitField HorizontalTextAlignment = BitFieldFactory.getInstance(14);
    public static final short HORIZONTAL_TEXT_ALIGNMENT_LEFT_ALIGNED = 1;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_CENTERED = 2;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_RIGHT_ALIGNED = 3;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_JUSTIFIED = 4;
    private BitField VerticalTextAlignment = BitFieldFactory.getInstance(112);
    public static final short VERTICAL_TEXT_ALIGNMENT_TOP = 1;
    public static final short VERTICAL_TEXT_ALIGNMENT_CENTER = 2;
    public static final short VERTICAL_TEXT_ALIGNMENT_BOTTOM = 3;
    public static final short VERTICAL_TEXT_ALIGNMENT_JUSTIFY = 4;
    private BitField reserved2 = BitFieldFactory.getInstance(384);
    private BitField textLocked = BitFieldFactory.getInstance(512);
    private BitField reserved3 = BitFieldFactory.getInstance(64512);
    private short field_2_textOrientation;
    public static final short TEXT_ORIENTATION_NONE = 0;
    public static final short TEXT_ORIENTATION_TOP_TO_BOTTOM = 1;
    public static final short TEXT_ORIENTATION_ROT_RIGHT = 2;
    public static final short TEXT_ORIENTATION_ROT_LEFT = 3;
    private short field_3_reserved4;
    private short field_4_reserved5;
    private short field_5_reserved6;
    private short field_6_textLength;
    private short field_7_formattingRunLength;
    private int field_8_reserved7;

    public TextObjectBaseRecord() {
    }

    public TextObjectBaseRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 438) {
            throw new RecordFormatException("Not a TextObjectBase record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_options = recordInputStream.readShort();
        this.field_2_textOrientation = recordInputStream.readShort();
        this.field_3_reserved4 = recordInputStream.readShort();
        this.field_4_reserved5 = recordInputStream.readShort();
        this.field_5_reserved6 = recordInputStream.readShort();
        this.field_6_textLength = recordInputStream.readShort();
        this.field_7_formattingRunLength = recordInputStream.readShort();
        this.field_8_reserved7 = recordInputStream.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TXO]\n");
        stringBuffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .reserved1                = ").append(this.isReserved1()).append('\n');
        stringBuffer.append("         .HorizontalTextAlignment     = ").append(this.getHorizontalTextAlignment()).append('\n');
        stringBuffer.append("         .VerticalTextAlignment     = ").append(this.getVerticalTextAlignment()).append('\n');
        stringBuffer.append("         .reserved2                = ").append(this.getReserved2()).append('\n');
        stringBuffer.append("         .textLocked               = ").append(this.isTextLocked()).append('\n');
        stringBuffer.append("         .reserved3                = ").append(this.getReserved3()).append('\n');
        stringBuffer.append("    .textOrientation      = ").append("0x").append(HexDump.toHex(this.getTextOrientation())).append(" (").append(this.getTextOrientation()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved4            = ").append("0x").append(HexDump.toHex(this.getReserved4())).append(" (").append(this.getReserved4()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved5            = ").append("0x").append(HexDump.toHex(this.getReserved5())).append(" (").append(this.getReserved5()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved6            = ").append("0x").append(HexDump.toHex(this.getReserved6())).append(" (").append(this.getReserved6()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .textLength           = ").append("0x").append(HexDump.toHex(this.getTextLength())).append(" (").append(this.getTextLength()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .formattingRunLength  = ").append("0x").append(HexDump.toHex(this.getFormattingRunLength())).append(" (").append(this.getFormattingRunLength()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .reserved7            = ").append("0x").append(HexDump.toHex(this.getReserved7())).append(" (").append(this.getReserved7()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/TXO]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)438);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_options);
        LittleEndian.putShort(byArray, 6 + n + n2, this.field_2_textOrientation);
        LittleEndian.putShort(byArray, 8 + n + n2, this.field_3_reserved4);
        LittleEndian.putShort(byArray, 10 + n + n2, this.field_4_reserved5);
        LittleEndian.putShort(byArray, 12 + n + n2, this.field_5_reserved6);
        LittleEndian.putShort(byArray, 14 + n + n2, this.field_6_textLength);
        LittleEndian.putShort(byArray, 16 + n + n2, this.field_7_formattingRunLength);
        LittleEndian.putInt(byArray, 18 + n + n2, this.field_8_reserved7);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 438;
    }

    public Object clone() {
        TextObjectBaseRecord textObjectBaseRecord = new TextObjectBaseRecord();
        textObjectBaseRecord.field_1_options = this.field_1_options;
        textObjectBaseRecord.field_2_textOrientation = this.field_2_textOrientation;
        textObjectBaseRecord.field_3_reserved4 = this.field_3_reserved4;
        textObjectBaseRecord.field_4_reserved5 = this.field_4_reserved5;
        textObjectBaseRecord.field_5_reserved6 = this.field_5_reserved6;
        textObjectBaseRecord.field_6_textLength = this.field_6_textLength;
        textObjectBaseRecord.field_7_formattingRunLength = this.field_7_formattingRunLength;
        textObjectBaseRecord.field_8_reserved7 = this.field_8_reserved7;
        return textObjectBaseRecord;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public void setOptions(short s) {
        this.field_1_options = s;
    }

    public short getTextOrientation() {
        return this.field_2_textOrientation;
    }

    public void setTextOrientation(short s) {
        this.field_2_textOrientation = s;
    }

    public short getReserved4() {
        return this.field_3_reserved4;
    }

    public void setReserved4(short s) {
        this.field_3_reserved4 = s;
    }

    public short getReserved5() {
        return this.field_4_reserved5;
    }

    public void setReserved5(short s) {
        this.field_4_reserved5 = s;
    }

    public short getReserved6() {
        return this.field_5_reserved6;
    }

    public void setReserved6(short s) {
        this.field_5_reserved6 = s;
    }

    public short getTextLength() {
        return this.field_6_textLength;
    }

    public void setTextLength(short s) {
        this.field_6_textLength = s;
    }

    public short getFormattingRunLength() {
        return this.field_7_formattingRunLength;
    }

    public void setFormattingRunLength(short s) {
        this.field_7_formattingRunLength = s;
    }

    public int getReserved7() {
        return this.field_8_reserved7;
    }

    public void setReserved7(int n) {
        this.field_8_reserved7 = n;
    }

    public void setReserved1(boolean bl) {
        this.field_1_options = this.reserved1.setShortBoolean(this.field_1_options, bl);
    }

    public boolean isReserved1() {
        return this.reserved1.isSet(this.field_1_options);
    }

    public void setHorizontalTextAlignment(short s) {
        this.field_1_options = this.HorizontalTextAlignment.setShortValue(this.field_1_options, s);
    }

    public short getHorizontalTextAlignment() {
        return this.HorizontalTextAlignment.getShortValue(this.field_1_options);
    }

    public void setVerticalTextAlignment(short s) {
        this.field_1_options = this.VerticalTextAlignment.setShortValue(this.field_1_options, s);
    }

    public short getVerticalTextAlignment() {
        return this.VerticalTextAlignment.getShortValue(this.field_1_options);
    }

    public void setReserved2(short s) {
        this.field_1_options = this.reserved2.setShortValue(this.field_1_options, s);
    }

    public short getReserved2() {
        return this.reserved2.getShortValue(this.field_1_options);
    }

    public void setTextLocked(boolean bl) {
        this.field_1_options = this.textLocked.setShortBoolean(this.field_1_options, bl);
    }

    public boolean isTextLocked() {
        return this.textLocked.isSet(this.field_1_options);
    }

    public void setReserved3(short s) {
        this.field_1_options = this.reserved3.setShortValue(this.field_1_options, s);
    }

    public short getReserved3() {
        return this.reserved3.getShortValue(this.field_1_options);
    }
}

