/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class TabIdRecord
extends Record {
    public static final short sid = 317;
    public short[] field_1_tabids;

    public TabIdRecord() {
    }

    public TabIdRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 317) {
            throw new RecordFormatException("NOT A TABID RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_tabids = new short[recordInputStream.remaining() / 2];
        for (int i = 0; i < this.field_1_tabids.length; ++i) {
            this.field_1_tabids[i] = recordInputStream.readShort();
        }
    }

    public void setTabIdArray(short[] sArray) {
        this.field_1_tabids = sArray;
    }

    public short[] getTabIdArray() {
        return this.field_1_tabids;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TABID]\n");
        stringBuffer.append("    .elements        = ").append(this.field_1_tabids.length).append("\n");
        for (int i = 0; i < this.field_1_tabids.length; ++i) {
            stringBuffer.append("    .element_" + i + "       = ").append(this.field_1_tabids[i]).append("\n");
        }
        stringBuffer.append("[/TABID]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        short[] sArray = this.getTabIdArray();
        short s = (short)(sArray.length * 2);
        int n2 = 4;
        LittleEndian.putShort(byArray, 0 + n, (short)317);
        LittleEndian.putShort(byArray, 2 + n, s);
        for (int i = 0; i < s / 2; ++i) {
            LittleEndian.putShort(byArray, n2 + n, sArray[i]);
            n2 += 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getTabIdArray().length * 2;
    }

    public short getSid() {
        return 317;
    }
}

