/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.UnicodeString;
import com.fr.third.org.apache.poi.util.LittleEndian;

public final class SupBookRecord
extends Record {
    public static final short sid = 430;
    private static final short SMALL_RECORD_SIZE = 4;
    private static final short TAG_INTERNAL_REFERENCES = 1025;
    private static final short TAG_ADD_IN_FUNCTIONS = 14849;
    private short field_1_number_of_sheets;
    private UnicodeString field_2_encoded_url;
    private UnicodeString[] field_3_sheet_names;
    private boolean _isAddInFunctions;

    public static SupBookRecord createInternalReferences(short s) {
        return new SupBookRecord(false, s);
    }

    public static SupBookRecord createAddInFunctions() {
        return new SupBookRecord(true, 0);
    }

    public static SupBookRecord createExternalReferences(UnicodeString unicodeString, UnicodeString[] unicodeStringArray) {
        return new SupBookRecord(unicodeString, unicodeStringArray);
    }

    private SupBookRecord(boolean bl, short s) {
        this.field_1_number_of_sheets = s;
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        this._isAddInFunctions = bl;
    }

    public SupBookRecord(UnicodeString unicodeString, UnicodeString[] unicodeStringArray) {
        this.field_1_number_of_sheets = (short)unicodeStringArray.length;
        this.field_2_encoded_url = unicodeString;
        this.field_3_sheet_names = unicodeStringArray;
        this._isAddInFunctions = false;
    }

    public SupBookRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 430) {
            throw new RecordFormatException("NOT An ExternSheet RECORD");
        }
    }

    public boolean isExternalReferences() {
        return this.field_3_sheet_names != null;
    }

    public boolean isInternalReferences() {
        return this.field_3_sheet_names == null && !this._isAddInFunctions;
    }

    public boolean isAddInFunctions() {
        return this.field_3_sheet_names == null && this._isAddInFunctions;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_number_of_sheets = recordInputStream.readShort();
        if (recordInputStream.getLength() > 4) {
            this._isAddInFunctions = false;
            this.field_2_encoded_url = recordInputStream.readUnicodeString();
            UnicodeString[] unicodeStringArray = new UnicodeString[this.field_1_number_of_sheets];
            for (int i = 0; i < unicodeStringArray.length; ++i) {
                unicodeStringArray[i] = recordInputStream.readUnicodeString();
            }
            this.field_3_sheet_names = unicodeStringArray;
            return;
        }
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        short s = recordInputStream.readShort();
        if (s == 1025) {
            this._isAddInFunctions = false;
        } else if (s == 14849) {
            this._isAddInFunctions = true;
            if (this.field_1_number_of_sheets != 1) {
                throw new RuntimeException("Expected 0x0001 for number of sheets field in 'Add-In Functions' but got (" + this.field_1_number_of_sheets + ")");
            }
        } else {
            throw new RuntimeException("invalid EXTERNALBOOK code (" + Integer.toHexString(s) + ")");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [SUPBOOK ");
        if (this.isExternalReferences()) {
            stringBuffer.append("External References");
            stringBuffer.append(" nSheets=").append(this.field_1_number_of_sheets);
            stringBuffer.append(" url=").append(this.field_2_encoded_url);
        } else if (this._isAddInFunctions) {
            stringBuffer.append("Add-In Functions");
        } else {
            stringBuffer.append("Internal References ");
            stringBuffer.append(" nSheets= ").append(this.field_1_number_of_sheets);
        }
        return stringBuffer.toString();
    }

    private int getDataSize() {
        if (!this.isExternalReferences()) {
            return 4;
        }
        int n = 2;
        UnicodeString.UnicodeRecordStats unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
        this.field_2_encoded_url.getRecordSize(unicodeRecordStats);
        n += unicodeRecordStats.recordSize;
        for (int i = 0; i < this.field_3_sheet_names.length; ++i) {
            unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
            this.field_3_sheet_names[i].getRecordSize(unicodeRecordStats);
            n += unicodeRecordStats.recordSize;
        }
        return n;
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)430);
        int n2 = this.getDataSize();
        LittleEndian.putShort(byArray, 2 + n, (short)n2);
        LittleEndian.putShort(byArray, 4 + n, this.field_1_number_of_sheets);
        if (this.isExternalReferences()) {
            int n3 = 6 + n;
            UnicodeString.UnicodeRecordStats unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
            this.field_2_encoded_url.serialize(unicodeRecordStats, n3, byArray);
            n3 += unicodeRecordStats.recordSize;
            for (int i = 0; i < this.field_3_sheet_names.length; ++i) {
                unicodeRecordStats = new UnicodeString.UnicodeRecordStats();
                this.field_3_sheet_names[i].serialize(unicodeRecordStats, n3, byArray);
                n3 += unicodeRecordStats.recordSize;
            }
        } else {
            short s = this._isAddInFunctions ? (short)14849 : 1025;
            LittleEndian.putShort(byArray, 6 + n, s);
        }
        return n2 + 4;
    }

    public void setNumberOfSheets(short s) {
        this.field_1_number_of_sheets = s;
    }

    public short getNumberOfSheets() {
        return this.field_1_number_of_sheets;
    }

    public int getRecordSize() {
        return this.getDataSize() + 4;
    }

    public short getSid() {
        return 430;
    }

    public UnicodeString getURL() {
        return this.field_2_encoded_url;
    }

    public UnicodeString[] getSheetNames() {
        return (UnicodeString[])this.field_3_sheet_names.clone();
    }
}

