/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class StyleRecord
extends Record {
    public static final short sid = 659;
    public static final short STYLE_USER_DEFINED = 0;
    public static final short STYLE_BUILT_IN = 1;
    private short field_1_xf_index;
    private byte field_2_builtin_style;
    private byte field_3_outline_style_level;
    private short field_2_name_length;
    private byte field_3_string_options;
    private BitField fHighByte;
    private String field_4_name;

    public StyleRecord() {
    }

    public StyleRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 659) {
            throw new RecordFormatException("NOT A STYLE RECORD");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.fHighByte = BitFieldFactory.getInstance(1);
        this.field_1_xf_index = recordInputStream.readShort();
        if (this.getType() == 1) {
            this.field_2_builtin_style = recordInputStream.readByte();
            this.field_3_outline_style_level = recordInputStream.readByte();
        } else if (this.getType() == 0) {
            this.field_2_name_length = recordInputStream.readShort();
            if (recordInputStream.remaining() > 0) {
                this.field_3_string_options = recordInputStream.readByte();
                byte[] byArray = recordInputStream.readRemainder();
                this.field_4_name = this.fHighByte.isSet(this.field_3_string_options) ? StringUtil.getFromUnicodeBE(byArray, 0, this.field_2_name_length) : StringUtil.getFromCompressedUnicode(byArray, 0, this.field_2_name_length);
            }
        }
    }

    public void setIndex(short s) {
        this.field_1_xf_index = s;
    }

    public void setType(short s) {
        this.field_1_xf_index = this.setField(this.field_1_xf_index, s, 32768, 15);
    }

    public void setXFIndex(short s) {
        this.field_1_xf_index = this.setField(this.field_1_xf_index, s, 8191, 0);
    }

    public void setNameLength(byte by) {
        this.field_2_name_length = by;
    }

    public void setName(String string) {
        this.field_4_name = string;
    }

    public void setBuiltin(byte by) {
        this.field_2_builtin_style = by;
    }

    public void setOutlineStyleLevel(byte by) {
        this.field_3_outline_style_level = by;
    }

    public short getIndex() {
        return this.field_1_xf_index;
    }

    public short getType() {
        return (short)((this.field_1_xf_index & 0x8000) >> 15);
    }

    public short getXFIndex() {
        return (short)(this.field_1_xf_index & 0x1FFF);
    }

    public short getNameLength() {
        return this.field_2_name_length;
    }

    public String getName() {
        return this.field_4_name;
    }

    public byte getBuiltin() {
        return this.field_2_builtin_style;
    }

    public byte getOutlineStyleLevel() {
        return this.field_3_outline_style_level;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[STYLE]\n");
        stringBuffer.append("    .xf_index_raw    = ").append(Integer.toHexString(this.getIndex())).append("\n");
        stringBuffer.append("        .type        = ").append(Integer.toHexString(this.getType())).append("\n");
        stringBuffer.append("        .xf_index    = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        if (this.getType() == 1) {
            stringBuffer.append("    .builtin_style   = ").append(Integer.toHexString(this.getBuiltin())).append("\n");
            stringBuffer.append("    .outline_level   = ").append(Integer.toHexString(this.getOutlineStyleLevel())).append("\n");
        } else if (this.getType() == 0) {
            stringBuffer.append("    .name_length     = ").append(Integer.toHexString(this.getNameLength())).append("\n");
            stringBuffer.append("    .name            = ").append(this.getName()).append("\n");
        }
        stringBuffer.append("[/STYLE]\n");
        return stringBuffer.toString();
    }

    private short setField(int n, int n2, int n3, int n4) {
        return (short)(n & ~n3 | n2 << n4 & n3);
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)659);
        if (this.getType() == 1) {
            LittleEndian.putShort(byArray, 2 + n, (short)4);
        } else {
            LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        }
        LittleEndian.putShort(byArray, 4 + n, this.getIndex());
        if (this.getType() == 1) {
            byArray[6 + n] = this.getBuiltin();
            byArray[7 + n] = this.getOutlineStyleLevel();
        } else {
            LittleEndian.putShort(byArray, 6 + n, this.getNameLength());
            byArray[8 + n] = this.field_3_string_options;
            StringUtil.putCompressedUnicode(this.getName(), byArray, 9 + n);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int n = this.getType() == 1 ? 8 : (this.fHighByte.isSet(this.field_3_string_options) ? 9 + 2 * this.getNameLength() : 9 + this.getNameLength());
        return n;
    }

    public short getSid() {
        return 659;
    }
}

