/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class StringRecord
extends Record {
    public static final short sid = 519;
    private int field_1_string_length;
    private byte field_2_unicode_flag;
    private String field_3_string;

    public StringRecord() {
    }

    public StringRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 519) {
            throw new RecordFormatException("Not a valid StringRecord");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_string_length = recordInputStream.readShort();
        this.field_2_unicode_flag = recordInputStream.readByte();
        byte[] byArray = recordInputStream.readRemainder();
        this.field_3_string = this.isUnCompressedUnicode() ? StringUtil.getFromUnicodeLE(byArray, 0, this.field_1_string_length) : StringUtil.getFromCompressedUnicode(byArray, 0, this.field_1_string_length);
    }

    public void processContinueRecord(byte[] byArray) {
        this.field_3_string = this.isUnCompressedUnicode() ? this.field_3_string + StringUtil.getFromUnicodeLE(byArray, 0, this.field_1_string_length - this.field_3_string.length()) : this.field_3_string + StringUtil.getFromCompressedUnicode(byArray, 0, this.field_1_string_length - this.field_3_string.length());
    }

    public boolean isInValueSection() {
        return true;
    }

    private int getStringByteLength() {
        return this.isUnCompressedUnicode() ? this.field_1_string_length * 2 : this.field_1_string_length;
    }

    public int getRecordSize() {
        return 7 + this.getStringByteLength();
    }

    public boolean isUnCompressedUnicode() {
        return this.field_2_unicode_flag == 1;
    }

    public int serialize(int n, byte[] byArray) {
        LittleEndian.putShort(byArray, 0 + n, (short)519);
        LittleEndian.putShort(byArray, 2 + n, (short)(3 + this.getStringByteLength()));
        LittleEndian.putUShort(byArray, 4 + n, this.field_1_string_length);
        byArray[6 + n] = this.field_2_unicode_flag;
        if (this.isUnCompressedUnicode()) {
            StringUtil.putUnicodeLE(this.field_3_string, byArray, 7 + n);
        } else {
            StringUtil.putCompressedUnicode(this.field_3_string, byArray, 7 + n);
        }
        return this.getRecordSize();
    }

    public short getSid() {
        return 519;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setCompressedFlag(byte by) {
        this.field_2_unicode_flag = by;
    }

    public void setString(String string) {
        this.field_1_string_length = string.length();
        this.field_3_string = string;
        this.setCompressedFlag(StringUtil.hasMultibyte(string) ? (byte)1 : 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[STRING]\n");
        stringBuffer.append("    .string            = ").append(this.field_3_string).append("\n");
        stringBuffer.append("[/STRING]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        StringRecord stringRecord = new StringRecord();
        stringRecord.field_1_string_length = this.field_1_string_length;
        stringRecord.field_2_unicode_flag = this.field_2_unicode_flag;
        stringRecord.field_3_string = this.field_3_string;
        return stringRecord;
    }
}

