/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class SheetPropertiesRecord
extends Record {
    public static final short sid = 4164;
    private short field_1_flags;
    private BitField chartTypeManuallyFormatted = BitFieldFactory.getInstance(1);
    private BitField plotVisibleOnly = BitFieldFactory.getInstance(2);
    private BitField doNotSizeWithWindow = BitFieldFactory.getInstance(4);
    private BitField defaultPlotDimensions = BitFieldFactory.getInstance(8);
    private BitField autoPlotArea = BitFieldFactory.getInstance(16);
    private byte field_2_empty;
    public static final byte EMPTY_NOT_PLOTTED = 0;
    public static final byte EMPTY_ZERO = 1;
    public static final byte EMPTY_INTERPOLATED = 2;

    public SheetPropertiesRecord() {
    }

    public SheetPropertiesRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4164) {
            throw new RecordFormatException("Not a SheetProperties record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_flags = recordInputStream.readShort();
        this.field_2_empty = recordInputStream.readByte();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SHTPROPS]\n");
        stringBuffer.append("    .flags                = ").append("0x").append(HexDump.toHex(this.getFlags())).append(" (").append(this.getFlags()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .chartTypeManuallyFormatted     = ").append(this.isChartTypeManuallyFormatted()).append('\n');
        stringBuffer.append("         .plotVisibleOnly          = ").append(this.isPlotVisibleOnly()).append('\n');
        stringBuffer.append("         .doNotSizeWithWindow      = ").append(this.isDoNotSizeWithWindow()).append('\n');
        stringBuffer.append("         .defaultPlotDimensions     = ").append(this.isDefaultPlotDimensions()).append('\n');
        stringBuffer.append("         .autoPlotArea             = ").append(this.isAutoPlotArea()).append('\n');
        stringBuffer.append("    .empty                = ").append("0x").append(HexDump.toHex(this.getEmpty())).append(" (").append(this.getEmpty()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/SHTPROPS]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4164);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_flags);
        byArray[6 + n + n2] = this.field_2_empty;
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 7;
    }

    public short getSid() {
        return 4164;
    }

    public Object clone() {
        SheetPropertiesRecord sheetPropertiesRecord = new SheetPropertiesRecord();
        sheetPropertiesRecord.field_1_flags = this.field_1_flags;
        sheetPropertiesRecord.field_2_empty = this.field_2_empty;
        return sheetPropertiesRecord;
    }

    public short getFlags() {
        return this.field_1_flags;
    }

    public void setFlags(short s) {
        this.field_1_flags = s;
    }

    public byte getEmpty() {
        return this.field_2_empty;
    }

    public void setEmpty(byte by) {
        this.field_2_empty = by;
    }

    public void setChartTypeManuallyFormatted(boolean bl) {
        this.field_1_flags = this.chartTypeManuallyFormatted.setShortBoolean(this.field_1_flags, bl);
    }

    public boolean isChartTypeManuallyFormatted() {
        return this.chartTypeManuallyFormatted.isSet(this.field_1_flags);
    }

    public void setPlotVisibleOnly(boolean bl) {
        this.field_1_flags = this.plotVisibleOnly.setShortBoolean(this.field_1_flags, bl);
    }

    public boolean isPlotVisibleOnly() {
        return this.plotVisibleOnly.isSet(this.field_1_flags);
    }

    public void setDoNotSizeWithWindow(boolean bl) {
        this.field_1_flags = this.doNotSizeWithWindow.setShortBoolean(this.field_1_flags, bl);
    }

    public boolean isDoNotSizeWithWindow() {
        return this.doNotSizeWithWindow.isSet(this.field_1_flags);
    }

    public void setDefaultPlotDimensions(boolean bl) {
        this.field_1_flags = this.defaultPlotDimensions.setShortBoolean(this.field_1_flags, bl);
    }

    public boolean isDefaultPlotDimensions() {
        return this.defaultPlotDimensions.isSet(this.field_1_flags);
    }

    public void setAutoPlotArea(boolean bl) {
        this.field_1_flags = this.autoPlotArea.setShortBoolean(this.field_1_flags, bl);
    }

    public boolean isAutoPlotArea() {
        return this.autoPlotArea.isSet(this.field_1_flags);
    }
}

