/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaNPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtgBase;
import com.fr.third.org.apache.poi.hssf.record.formula.OperandPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.Ptg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefNPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.RefPtgBase;
import java.util.Stack;

public final class SharedFormulaRecord
extends Record {
    public static final short sid = 1212;
    private int field_1_first_row;
    private int field_2_last_row;
    private short field_3_first_column;
    private short field_4_last_column;
    private int field_5_reserved;
    private short field_6_expression_len;
    private Stack field_7_parsed_expr;

    public SharedFormulaRecord() {
    }

    public SharedFormulaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 1212) {
            throw new RecordFormatException("Not a valid SharedFormula");
        }
    }

    public int getFirstRow() {
        return this.field_1_first_row;
    }

    public int getLastRow() {
        return this.field_2_last_row;
    }

    public short getFirstColumn() {
        return this.field_3_first_column;
    }

    public short getLastColumn() {
        return this.field_4_last_column;
    }

    public short getExpressionLength() {
        return this.field_6_expression_len;
    }

    public int serialize(int n, byte[] byArray) {
        throw new UnsupportedOperationException("Cannot serialize a SharedFormulaRecord");
    }

    public int getRecordSize() {
        throw new UnsupportedOperationException("Cannot get the size for a SharedFormulaRecord");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SHARED FORMULA RECORD:" + Integer.toHexString(1212) + "]\n");
        stringBuffer.append("    .id        = ").append(Integer.toHexString(1212)).append("\n");
        stringBuffer.append("    .first_row       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        stringBuffer.append("    .last_row    = ").append(Integer.toHexString(this.getLastRow())).append("\n");
        stringBuffer.append("    .first_column       = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        stringBuffer.append("    .last_column    = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        stringBuffer.append("    .reserved    = ").append(Integer.toHexString(this.field_5_reserved)).append("\n");
        stringBuffer.append("    .expressionlength= ").append(this.getExpressionLength()).append("\n");
        stringBuffer.append("    .numptgsinarray  = ").append(this.field_7_parsed_expr.size()).append("\n");
        for (int i = 0; i < this.field_7_parsed_expr.size(); ++i) {
            stringBuffer.append("Formula ").append(i).append("\n").append(this.field_7_parsed_expr.get(i).toString()).append("\n");
        }
        stringBuffer.append("[/SHARED FORMULA RECORD]\n");
        return stringBuffer.toString();
    }

    public short getSid() {
        return 1212;
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_first_row = recordInputStream.readUShort();
        this.field_2_last_row = recordInputStream.readUShort();
        this.field_3_first_column = recordInputStream.readUByte();
        this.field_4_last_column = recordInputStream.readUByte();
        this.field_5_reserved = recordInputStream.readShort();
        this.field_6_expression_len = recordInputStream.readShort();
        this.field_7_parsed_expr = this.getParsedExpressionTokens(recordInputStream);
    }

    private Stack getParsedExpressionTokens(RecordInputStream recordInputStream) {
        Stack<Ptg> stack = new Stack<Ptg>();
        while (recordInputStream.remaining() != 0) {
            Ptg ptg = Ptg.createPtg(recordInputStream);
            stack.push(ptg);
        }
        return stack;
    }

    public boolean isFormulaInShared(FormulaRecord formulaRecord) {
        int n = formulaRecord.getRow();
        short s = formulaRecord.getColumn();
        return this.getFirstRow() <= n && this.getLastRow() >= n && this.getFirstColumn() <= s && this.getLastColumn() >= s;
    }

    protected static Stack convertSharedFormulas(Stack stack, int n, int n2) {
        Stack<Ptg> stack2 = new Stack<Ptg>();
        if (stack != null) {
            for (int i = 0; i < stack.size(); ++i) {
                OperandPtg operandPtg;
                Ptg ptg = (Ptg)stack.get(i);
                byte by = -1;
                if (!ptg.isBaseToken()) {
                    by = ptg.getPtgClass();
                }
                if (ptg instanceof RefNPtg) {
                    operandPtg = (RefNPtg)ptg;
                    ptg = new RefPtg(SharedFormulaRecord.fixupRelativeRow(n, ((RefPtgBase)operandPtg).getRow(), ((RefPtgBase)operandPtg).isRowRelative()), SharedFormulaRecord.fixupRelativeColumn(n2, ((RefPtgBase)operandPtg).getColumn(), ((RefPtgBase)operandPtg).isColRelative()), ((RefPtgBase)operandPtg).isRowRelative(), ((RefPtgBase)operandPtg).isColRelative());
                } else if (ptg instanceof AreaNPtg) {
                    operandPtg = (AreaNPtg)ptg;
                    ptg = new AreaPtg(SharedFormulaRecord.fixupRelativeRow(n, ((AreaPtgBase)operandPtg).getFirstRow(), ((AreaPtgBase)operandPtg).isFirstRowRelative()), SharedFormulaRecord.fixupRelativeRow(n, ((AreaPtgBase)operandPtg).getLastRow(), ((AreaPtgBase)operandPtg).isLastRowRelative()), SharedFormulaRecord.fixupRelativeColumn(n2, ((AreaPtgBase)operandPtg).getFirstColumn(), ((AreaPtgBase)operandPtg).isFirstColRelative()), SharedFormulaRecord.fixupRelativeColumn(n2, ((AreaPtgBase)operandPtg).getLastColumn(), ((AreaPtgBase)operandPtg).isLastColRelative()), ((AreaPtgBase)operandPtg).isFirstRowRelative(), ((AreaPtgBase)operandPtg).isLastRowRelative(), ((AreaPtgBase)operandPtg).isFirstColRelative(), ((AreaPtgBase)operandPtg).isLastColRelative());
                }
                if (!ptg.isBaseToken()) {
                    ptg.setClass(by);
                }
                stack2.add(ptg);
            }
        }
        return stack2;
    }

    public void convertSharedFormulaRecord(FormulaRecord formulaRecord) {
        int n = formulaRecord.getRow();
        short s = formulaRecord.getColumn();
        if (!this.isFormulaInShared(formulaRecord)) {
            throw new RuntimeException("Shared Formula Conversion: Coding Error");
        }
        formulaRecord.setExpressionLength(this.getExpressionLength());
        Stack stack = SharedFormulaRecord.convertSharedFormulas(this.field_7_parsed_expr, n, s);
        formulaRecord.setParsedExpression(stack);
        formulaRecord.setSharedFormula(false);
    }

    private static int fixupRelativeColumn(int n, int n2, boolean bl) {
        if (bl) {
            return n2 + n & 0xFF;
        }
        return n2;
    }

    private static int fixupRelativeRow(int n, int n2, boolean bl) {
        if (bl) {
            return n2 + n & 0xFFFF;
        }
        return n2;
    }

    public boolean isInValueSection() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object clone() {
        throw new UnsupportedOperationException("Cannot clone a SharedFormulaRecord");
    }
}

