/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;
import com.fr.third.org.apache.poi.util.StringUtil;

public class SeriesTextRecord
extends Record {
    public static final short sid = 4109;
    private short field_1_id;
    private byte field_2_textLength;
    private byte field_3_undocumented;
    private String field_4_text;

    public SeriesTextRecord() {
    }

    public SeriesTextRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4109) {
            throw new RecordFormatException("Not a SeriesText record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_id = recordInputStream.readShort();
        this.field_2_textLength = recordInputStream.readByte();
        this.field_3_undocumented = recordInputStream.readByte();
        this.field_4_text = recordInputStream.readUnicodeLEString(this.field_2_textLength);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SERIESTEXT]\n");
        stringBuffer.append("    .id                   = ").append("0x").append(HexDump.toHex(this.getId())).append(" (").append(this.getId()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .textLength           = ").append("0x").append(HexDump.toHex(this.getTextLength())).append(" (").append(this.getTextLength()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .undocumented         = ").append("0x").append(HexDump.toHex(this.getUndocumented())).append(" (").append(this.getUndocumented()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .text                 = ").append(" (").append(this.getText()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/SERIESTEXT]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4109);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_id);
        byArray[6 + n + n2] = this.field_2_textLength;
        byArray[7 + n + n2] = this.field_3_undocumented;
        StringUtil.putUnicodeLE(this.field_4_text, byArray, 8 + n + n2);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8 + this.field_2_textLength * 2;
    }

    public short getSid() {
        return 4109;
    }

    public Object clone() {
        SeriesTextRecord seriesTextRecord = new SeriesTextRecord();
        seriesTextRecord.field_1_id = this.field_1_id;
        seriesTextRecord.field_2_textLength = this.field_2_textLength;
        seriesTextRecord.field_3_undocumented = this.field_3_undocumented;
        seriesTextRecord.field_4_text = this.field_4_text;
        return seriesTextRecord;
    }

    public short getId() {
        return this.field_1_id;
    }

    public void setId(short s) {
        this.field_1_id = s;
    }

    public byte getTextLength() {
        return this.field_2_textLength;
    }

    public void setTextLength(byte by) {
        this.field_2_textLength = by;
    }

    public byte getUndocumented() {
        return this.field_3_undocumented;
    }

    public void setUndocumented(byte by) {
        this.field_3_undocumented = by;
    }

    public String getText() {
        return this.field_4_text;
    }

    public void setText(String string) {
        this.field_4_text = string;
    }
}

