/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class SeriesListRecord
extends Record {
    public static final short sid = 4118;
    private short[] field_1_seriesNumbers;

    public SeriesListRecord() {
    }

    public SeriesListRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4118) {
            throw new RecordFormatException("Not a SeriesList record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_seriesNumbers = recordInputStream.readShortArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SERIESLIST]\n");
        stringBuffer.append("    .seriesNumbers        = ").append(" (").append(this.getSeriesNumbers()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/SERIESLIST]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4118);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShortArray(byArray, 4 + n + n2, this.field_1_seriesNumbers);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.field_1_seriesNumbers.length * 2 + 2;
    }

    public short getSid() {
        return 4118;
    }

    public Object clone() {
        SeriesListRecord seriesListRecord = new SeriesListRecord();
        seriesListRecord.field_1_seriesNumbers = this.field_1_seriesNumbers;
        return seriesListRecord;
    }

    public short[] getSeriesNumbers() {
        return this.field_1_seriesNumbers;
    }

    public void setSeriesNumbers(short[] sArray) {
        this.field_1_seriesNumbers = sArray;
    }
}

