/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record;

import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordFormatException;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.util.BitField;
import com.fr.third.org.apache.poi.util.BitFieldFactory;
import com.fr.third.org.apache.poi.util.HexDump;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class SeriesLabelsRecord
extends Record {
    public static final short sid = 4108;
    private short field_1_formatFlags;
    private BitField showActual = BitFieldFactory.getInstance(1);
    private BitField showPercent = BitFieldFactory.getInstance(2);
    private BitField labelAsPercentage = BitFieldFactory.getInstance(4);
    private BitField smoothedLine = BitFieldFactory.getInstance(8);
    private BitField showLabel = BitFieldFactory.getInstance(16);
    private BitField showBubbleSizes = BitFieldFactory.getInstance(32);

    public SeriesLabelsRecord() {
    }

    public SeriesLabelsRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
    }

    protected void validateSid(short s) {
        if (s != 4108) {
            throw new RecordFormatException("Not a SeriesLabels record");
        }
    }

    protected void fillFields(RecordInputStream recordInputStream) {
        this.field_1_formatFlags = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ATTACHEDLABEL]\n");
        stringBuffer.append("    .formatFlags          = ").append("0x").append(HexDump.toHex(this.getFormatFlags())).append(" (").append(this.getFormatFlags()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("         .showActual               = ").append(this.isShowActual()).append('\n');
        stringBuffer.append("         .showPercent              = ").append(this.isShowPercent()).append('\n');
        stringBuffer.append("         .labelAsPercentage        = ").append(this.isLabelAsPercentage()).append('\n');
        stringBuffer.append("         .smoothedLine             = ").append(this.isSmoothedLine()).append('\n');
        stringBuffer.append("         .showLabel                = ").append(this.isShowLabel()).append('\n');
        stringBuffer.append("         .showBubbleSizes          = ").append(this.isShowBubbleSizes()).append('\n');
        stringBuffer.append("[/ATTACHEDLABEL]\n");
        return stringBuffer.toString();
    }

    public int serialize(int n, byte[] byArray) {
        int n2 = 0;
        LittleEndian.putShort(byArray, 0 + n, (short)4108);
        LittleEndian.putShort(byArray, 2 + n, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(byArray, 4 + n + n2, this.field_1_formatFlags);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4108;
    }

    public Object clone() {
        SeriesLabelsRecord seriesLabelsRecord = new SeriesLabelsRecord();
        seriesLabelsRecord.field_1_formatFlags = this.field_1_formatFlags;
        return seriesLabelsRecord;
    }

    public short getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(short s) {
        this.field_1_formatFlags = s;
    }

    public void setShowActual(boolean bl) {
        this.field_1_formatFlags = this.showActual.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isShowActual() {
        return this.showActual.isSet(this.field_1_formatFlags);
    }

    public void setShowPercent(boolean bl) {
        this.field_1_formatFlags = this.showPercent.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isShowPercent() {
        return this.showPercent.isSet(this.field_1_formatFlags);
    }

    public void setLabelAsPercentage(boolean bl) {
        this.field_1_formatFlags = this.labelAsPercentage.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isLabelAsPercentage() {
        return this.labelAsPercentage.isSet(this.field_1_formatFlags);
    }

    public void setSmoothedLine(boolean bl) {
        this.field_1_formatFlags = this.smoothedLine.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isSmoothedLine() {
        return this.smoothedLine.isSet(this.field_1_formatFlags);
    }

    public void setShowLabel(boolean bl) {
        this.field_1_formatFlags = this.showLabel.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isShowLabel() {
        return this.showLabel.isSet(this.field_1_formatFlags);
    }

    public void setShowBubbleSizes(boolean bl) {
        this.field_1_formatFlags = this.showBubbleSizes.setShortBoolean(this.field_1_formatFlags, bl);
    }

    public boolean isShowBubbleSizes() {
        return this.showBubbleSizes.isSet(this.field_1_formatFlags);
    }
}

